% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ddR.R
\name{dlapply}
\alias{dlapply}
\title{Distributed version of 'lapply'. Similar to \code{\link{dmapply}}, but permits only one iterable argument, and output.type is
always 'dlist'.}
\usage{
dlapply(X, FUN, ..., nparts = NULL)
}
\arguments{
\item{X}{vector, matrix, list, data.frame, dlist, darray, or dframe or other iterable object to supply to the function in FUN.}

\item{FUN}{the function to be applied to each element of 'X'.}

\item{...}{optional arguments to 'FUN'.}

\item{nparts}{number of partitions in the output dlist.}
}
\value{
a dlist with number of partitions specified in 'nparts'
}
\description{
Distributed version of 'lapply'. Similar to \code{\link{dmapply}}, but permits only one iterable argument, and output.type is
always 'dlist'.
}
\examples{
\dontrun{
a <- dlapply(1:5,function(x) x, nparts=3)
# A DList with 3 partitions,
# which in the aggregate contains the elements 1 through 5.
b <- dlapply(a,function(x) x+3) # AddR 3 to each element of dlist a.
}
}
\references{
Prasad, S., Fard, A., Gupta, V., Martinez, J., LeFevre, J., Xu, V., Hsu, M., Roy, I.
Large scale predictive analytics in Vertica: Fast data transfer, distributed model creation
and in-database prediction. _Sigmod 2015_, 1657-1668.

Venkataraman, S., Bodzsar, E., Roy, I., AuYoung, A., and
Schreiber, R. (2013) Presto: Distributed Machine Learning and
Graph Processing with Sparse Matrices. _EuroSys 2013_, 197-210.

Homepage: https://github.com/vertica/ddR
}

