% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdcov.R
\name{pdcov}
\alias{pdcov}
\alias{pdcor}
\title{Partial distance covariance}
\usage{
pdcov(x, y, z, type = c("U", "V"))

pdcor(x, y, z, type = c("U", "V"))
}
\arguments{
\item{x}{the matrix of x}

\item{y}{the matrix of y}

\item{z}{the matrix of z. Given the value of z, pdcov or pdcor between x and y is calcuated.}

\item{type}{"V" or "U", for V- or U-statistics of partial distance covariance or
correlation. The default value is "U".}
}
\description{
This method implements the method to compute the value of partial distance covariance
proposed by \cite{Székely and Rizzo, 2014}.
}
\examples{
z = matrix(rnorm(400),200,2)
x = matrix(rnorm(400),200,2)*z
y = matrix(rnorm(400),200,2)*z
pdcov(x,y,z)
pdcor(x,y,z)

}
\references{
Székely, G. J., & Rizzo, M. L. (2014). Partial distance correlation with methods for dissimilarities. The Annals of Statistics, 42(6), 2382-2412.
}
