% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distcov_function.R
\name{distsd}
\alias{distsd}
\title{Calculates the distance standard deviation \insertCite{edelmann2017distance}{dcortools}.}
\usage{
distsd(
  X,
  affine = FALSE,
  standardize = FALSE,
  bias.corr = FALSE,
  type.X = "sample",
  metr.X = "euclidean",
  use = "all",
  algorithm = "auto"
)
}
\arguments{
\item{X}{contains either the sample or its corresponding distance matrix.

In the first case, X can be provided either as a vector (if one-dimensional), a matrix or a data.frame (if two-dimensional or higher). 

In the second case, the input must be a distance matrix corresponding to the sample of interest.

If X is a sample, type.X must be specified as "sample". If X is a distance matrix, type.X must be specified as "distance".}

\item{affine}{logical; specifies if the affinely invariant distance standard deviation \insertCite{dueck2014affinely}{dcortools} should be calculated or not.}

\item{standardize}{logical; specifies if X and Y should be standardized dividing each component by its standard deviations. No effect when affine = TRUE.}

\item{bias.corr}{logical; specifies if the bias corrected version of the sample distance standard deviation \insertCite{huo2016fast}{dcortools} should be calculated.}

\item{type.X}{For "distance", X is interpreted as a distance matrix. For "sample", X is interpreted as a sample.}

\item{metr.X}{specifies the metric which should be used to compute the distance matrix for X (ignored when type.X = "distance").

 Options are "euclidean", "discrete", "alpha", "minkowski", "gaussian", "gaussauto", "boundsq" or user-specified metrics (see examples).
 
 For "alpha", "minkowski", "gaussian", "gaussauto" and "boundsq", the corresponding parameters are specified via "c(metric, parameter)", e.g. c("gaussian", 3) for a Gaussian metric with bandwidth parameter 3; the default parameter is 2 for "minkowski" and "1" for all other metrics.
 
 See \insertCite{lyons2013distance,sejdinovic2013equivalence,bottcher2017detecting;textual}{dcortools} for details.}

\item{use}{specifies how to treat missing values. "complete.obs" excludes observations containing NAs, "all" uses all observations.}

\item{algorithm}{specifies the algorithm used for calculating the distance standard deviation. 

"fast" uses an O(n log n) algorithm if the observations are one-dimensional and metr.X and metr.Y are either "euclidean" or "discrete", see also \insertCite{huo2016fast;textual}{dcortools}. 

"memsave" uses a memory saving version of the standard algorithm with computational complexity O(n^2) but requiring only O(n) memory. 

"standard" uses the classical algorithm. User-specified metrics always use the classical algorithm.

"auto" chooses the best algorithm for the specific setting using a rule of thumb.}
}
\value{
numeric; the distance standard deviation of X.
}
\description{
Calculates the distance standard deviation \insertCite{edelmann2017distance}{dcortools}.
}
\examples{
X <- rnorm(100)
distsd(X) # for more examples on the options see the documentation of distcov.
}
\references{
\insertRef{bottcher2017detecting}{dcortools}

\insertRef{dueck2014affinely}{dcortools}

\insertRef{edelmann2017distance}{dcortools}

\insertRef{huo2016fast}{dcortools}

\insertRef{lyons2013distance}{dcortools}

\insertRef{sejdinovic2013equivalence}{dcortools}

\insertRef{szekely2007}{dcortools}

\insertRef{szekely2009brownian}{dcortools}
}
