.onAttach <- function(libname, pkgname){
    ver <- read.dcf(file=system.file("DESCRIPTION", package=pkgname), 
                    fields=c("Version", "Date"))
    cat(paste(pkgname, ver[1], "\t", ver[2], "\n"))
    if (is.null(getOption("dclone.crit"))) {
        options("dclone.crit"=c(rhat=1.1))
    }
    invisible(NULL)
}

.onUnload <- function(libpath){
    if (!is.null(getOption("dclone.crit"))) {
        options("dclone.crit"=NULL)
    }
    invisible(NULL)
}

