% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-escape.r
\name{escape}
\alias{escape}
\alias{sql_vector}
\title{Escape/quote a string.}
\usage{
escape(x, parens = NA, collapse = " ", con = NULL)

sql_vector(x, parens = NA, collapse = " ", con = NULL)
}
\arguments{
\item{x}{An object to escape. Existing sql vectors will be left as is,
character vectors are escaped with single quotes, numeric vectors have
trailing \code{.0} added if they're whole numbers, identifiers are
escaped with double quotes.}

\item{parens, collapse}{Controls behaviour when multiple values are supplied.
\code{parens} should be a logical flag, or if \code{NA}, will wrap in
parens if length > 1.

Default behaviour: lists are always wrapped in parens and separated by
commas, identifiers are separated by commas and never wrapped,
atomic vectors are separated by spaces and wrapped in parens if needed.}

\item{con}{Database connection. If not specified, uses SQL 92 conventions.}
}
\description{
Escape/quote a string.
}
\examples{
# Doubles vs. integers
escape(1:5)
escape(c(1, 5.4))

# String vs known sql vs. sql identifier
escape("X")
escape(sql("X"))
escape(ident("X"))

# Escaping is idempotent
escape("X")
escape(escape("X"))
escape(escape(escape("X")))
}
