% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_awareness_report.R
\name{create_awareness_report}
\alias{create_awareness_report}
\title{Create Awareness Report}
\usage{
create_awareness_report(
  DD.dict,
  DS.data,
  non.NA.missing.codes = NA,
  threshold = 95,
  output.path = tempdir(),
  open.html = TRUE,
  fn.stem = "AwarenessReport"
)
}
\arguments{
\item{DD.dict}{Data dictionary.}

\item{DS.data}{Data set.}

\item{non.NA.missing.codes}{A user-defined vector of numerical missing value codes (e.g., -9999).}

\item{threshold}{Threshold for missingness of concern (as a percent).}

\item{output.path}{Path to the folder in which to create the HTML report document.}

\item{open.html}{If TRUE, open the HTML report document in the web browser.}

\item{fn.stem}{File name stem.}
}
\value{
Full path to the HTML report document.
}
\description{
This function generates an awareness report in HTML format, and optionally opens it in the web browser.
}
\examples{
\donttest{
data(ExampleB)
create_awareness_report(DD.dict.B, DS.data.B, non.NA.missing.codes=c(-9999),
   output.path= tempdir(), open.html = FALSE)
}
}
\seealso{
\code{\link{value_missing_table}}

\code{\link{missingness_summary}}
}
