% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daymet_grid_offset.r
\name{daymet_grid_offset}
\alias{daymet_grid_offset}
\title{Returns a time shifted (offset) dataset}
\usage{
daymet_grid_offset(data, offset = 264)
}
\arguments{
\item{data}{rasterStack or rasterBrick of 730 layers (2 consecutive years)}

\item{offset}{offset of the time series in DOY (default = 264, sept 21)}
}
\description{
Returns an offset dataset with data running from offset DOY in year - 1 to
offset DOY in the current year. Two years of data (730 data layers) are
required for this function to work. The output serves as input for further
data processing and / or ecosystem modelling efforts.
}
\examples{

\dontrun{
my_subset <- daymet_gridded_offset(mystack, offset = 264)
}
}
