\name{centroid}
\alias{centroid}
\alias{centroid.default}
\alias{print.centroid}
\alias{rcentroid}
\title{
Centroids of row groups (vegetation releves)
}
\description{
Given a two-dimensional data frame or matrix of vegetation data and group membership of rows (releve classification) a new matrix is derived with relative species frequency (0 to 1 scale) within groups. The matrix of centroids has as many rows as there are row groups in the vegetation matrix and the same number of  columns (species).
}
\usage{
centroid(nveg, grel,y,...)

\method{centroid}{default}(nveg, grel,y,...)
\method{print}{centroid}(x,...)
}
\arguments{
  \item{nveg}{
A data frame of vegetation releves (rows) by species (columns)
}
  \item{grel}{
A vector containing group membership of releves (rows), typically generated by \code{\link{hclust}} and \code{\link{cutree}}
}
  \item{y}{
Transformation of species scores: x'= x exp(y)
}
  \item{\dots}{
Further variables used for printing
}
  \item{x}{
A list of class "centroid" generated by centroid
}

}
\value{
An output list of class "centroid" with at least the following items:
\item{nrelgroups}{Number of rows of centroid table}
\item{nspec}{Number of columns of centroid table}
\item{freq.table}{A table of species frequencies within groups, unadjusted}
\item{prob.table}{A table of species frequencies within groups, adjusted (0-1)}
\item{dist.mat}{An nrelgroups by nrelgroups distance matrix of centroids}

}
\references{
Wildi, O. 2013. Data Analysis in Vegetation Ecology. 2nd ed. Wiley-Blackwell,
Chichester.
}
\author{
Otto Wildi
}
\note{
In function Mtabs() buit in as summary method
}
\examples{
# This generates a typical artificial vegetation data frame aveg
v1<- matrix(rep(0,200),nrow=10)        
diag(v1)<-1 ; diag(v1[,2:12])<-1 ; diag(v1[,3:13])<-2 ; diag(v1[,4:14])<-1
diag(v1[,5:15])<-1 ; diag(v1[5:8,3:6])<-3 ; aveg<- data.frame(v1[,2:13])

# First, groups of releves are formed by cluster analysis
require(vegan)
dr<- vegdist(aveg^0.5,method="bray")      # dr is distance matrix of rows
o.clr<- hclust(dr,method="ward")          # this is clustering
grel<- cutree(o.clr,k=3)                  # 3 row groups formed
o.centroid<- centroid(aveg,grel,y=0.5)
o.centroid                                # printing the matrix

}
\keyword{ array }
\keyword{ misc }
