% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard_mobile.R
\name{dauphin_mobile}
\alias{dauphin_mobile}
\alias{dauphin_landline}
\alias{dauphin_mobile_landline}
\alias{print.dauphin_mobile}
\title{Standardize Australian phone numbers}
\usage{
dauphin_mobile(mob, ignore_calling_code = NA)

dauphin_landline(
  landline,
  default_area_code = getOption("daiphin.default_area_code", 1L)
)

dauphin_mobile_landline(
  mob,
  landline,
  default_area_code = getOption("dauphin.default_area_code", 1L)
)

\method{print}{dauphin_mobile}(x, ...)
}
\arguments{
\item{mob, landline}{Character vectors in which mobile numbers and landline
numbers are expected.}

\item{ignore_calling_code}{\code{logical(1)} Whether to ignore the calling code
\code{+61} in the result.}

\item{default_area_code}{An integer between 1 and 10 giving, for
landline numbers with 8 digits, what area code should be set. By default,
it is \code{1L}, but users should set the option
\code{"dauphin.default_area_code"} so to correctly standardize non-mobile
numbers.}

\item{x}{A vector, generally a character vector, in which phone numbers
are expected.}

\item{...}{Arguments passed to other methods.}
}
\value{
Mobile phone numbers or landline numbers are represented as integer vectors. International
calling prefixes extend the number beyond the representation of signed
integers. We use \code{raw} vectors for the international prefix, if required.


If \code{ignore_calling_code = TRUE}, the integer vector is returned.
Elements of \code{x} for which the mobile phone number could not be
extracted map to \code{NA_integer_} in the result.

If \code{ignore_calling_code = FALSE}, then a list is returned. The second element
of the list is the calling prefix.

If \code{ignore_calling_code = NA} then it is set to \code{TRUE} if \code{x}
appears to have international prefixes already.

\describe{
\item{\code{dauphin_mobile}}{An integer vector, the integer representation of
the mobile phone. If the calling code is required or requested, a list
of two vectors is returned, with the second element a raw vector with
a representation of the corresponding number.}
\item{\code{dauphin_landline}}{An integer vector, the integer representation of the landline.}
\item{\code{dauphin_mobile_landline}}{A list of two vectors with the
mobile and landline vectors respectively, even if the character
vectors passed are in the wrong order (or partially in the wrong order).
 Useful if some of the entries
are in the wrong place.}

}
}
\description{
Standardize Australian phone numbers
}
\examples{
dauphin_mobile("0400 123 456")
dauphin_mobile("+61400123456", ignore_calling_code = FALSE)

dauphin_mobile_landline("0424 123 456", "03 1234 5678")
dauphin_mobile_landline(c("0424 123 456", "03 1234 5678"),
                        c(NA, "0424 123 456"))

}
