% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datelife_query_tnrs.R
\name{get_tnrs_names}
\alias{get_tnrs_names}
\title{Process a character vector of taxon names with TNRS}
\usage{
get_tnrs_names(
  input = c("Rhea americana", "Pterocnemia pennata", "Struthio camelus"),
  reference_taxonomy = "ott",
  ...
)
}
\arguments{
\item{input}{Taxon names as a character vector of taxon names. Two or more
names can be provided as a single comma separated string or concatenated with \code{\link[=c]{c()}}.}

\item{reference_taxonomy}{A character vector specifying the reference taxonomy to use for TNRS.
Options are "ott", "ncbi", "gbif" or "irmng". The function defaults to "ott".}

\item{...}{
  Arguments passed on to \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names}}
  \describe{
    \item{\code{context_name}}{name of the taxonomic context to be searched (length-one
character vector or \code{NULL}). Must match (case sensitive) one of the
values returned by \code{\link[rotl]{tnrs_contexts}}. Default to "All life".}
    \item{\code{do_approximate_matching}}{A logical indicating whether or not to
perform approximate string (a.k.a. \dQuote{fuzzy}) matching. Using
\code{FALSE} will greatly improve speed. Default, however, is \code{TRUE}.}
    \item{\code{ids}}{A vector of ids to use for identifying names. These will be
assigned to each name in the names array. If ids is provided, then ids and
names must be identical in length.}
    \item{\code{include_suppressed}}{Ordinarily, some quasi-taxa, such as incertae
sedis buckets and other non-OTUs, are suppressed from TNRS results. If
this parameter is true, these quasi-taxa are allowed as possible TNRS
results.}
  }}
}
\value{
A \code{datelifeTNRS} object, which is a list of three elements:
\describe{
\item{$cleaned_names}{A character vector of names provided as input.}
\item{$tnrs_names}{A character vector of taxon names processed with TNRS.}
\item{$ott_ids}{A numeric vector of Open Tree of Life Taxonomy (OTT) ids.}
}
}
\description{
\code{make_datelife_query2} always uses TNRS (Taxonomic Name Resolution Service
to process input taxon names, to correct misspellings and
taxonomic name variations with \code{\link[=tnrs_match]{tnrs_match()}}, a wrapper of \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}}).
}
