% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_species_from_ott.R
\name{get_all_descendant_species}
\alias{get_all_descendant_species}
\title{Quickly get all species belonging to a taxon from the Open Tree of Life Taxonomy (OTT)}
\usage{
get_all_descendant_species(taxon_name, ott_id)
}
\arguments{
\item{taxon_name}{A character vector providing an inclusive taxonomic name.}

\item{ott_id}{A numeric vector providig an Open Tree Taxonomic id number for
a taxonomic name. If provided, \code{taxon_name} is ignored.
Used in the context of OTT to detect invalid taxon names.}
}
\value{
A list of unique OTT names and OTT ids of species within the provided taxon.
}
\description{
This is less thorough than get_open_tree_species(), but much faster. It uses the fact
that something has just two names (genus and species) to assume that something is a
single species; if it has more than two names, it is assumed to be a subspecies so
it goes up one level in the hierarchy. It will return the subspecies and the species.
}
