% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrations_use.R
\name{use_calibrations_each}
\alias{use_calibrations_each}
\title{Date a given tree topology by using a given list of calibrations independently,
to generate multiple hypothesis of time of divergence}
\usage{
use_calibrations_each(phy = NULL, calibrations = NULL, ...)
}
\arguments{
\item{phy}{A \code{phylo} object to use as tree topology.}

\item{calibrations}{A \code{datelifeCalibrations} object, an output of \code{\link[=get_all_calibrations]{get_all_calibrations()}}.}

\item{...}{
  Arguments passed on to \code{\link[=use_calibrations]{use_calibrations}}
  \describe{
    \item{\code{dating_method}}{Tree dating algorithm to use. Options are "bladj" or "pathd8"
(Webb et al., 2008, \doi{10.1093/bioinformatics/btn358}; Britton et al., 2007,
\doi{10.1080/10635150701613783}).}
    \item{\code{type}}{The type of age to use as calibration. Options are "median", "mean", "min", or "max".}
  }}
}
\value{
A \code{multiPhylo} object of trees with branch lengths proportional to time.
}
\description{
\code{use_calibrations_each} wraps \code{use_calibrations} to take each set of
given calibrations and use it independently as constraints for BLADJ or PATHd8
to date a given tree topology.
}
\details{
If \code{phy} has no branch lengths, \code{dating_method} is ignores, and the function applies secondary
calibrations to date the tree with the BLADJ algorithm. See \code{\link[=make_bladj_tree]{make_bladj_tree()}} and \code{\link[=use_calibrations_bladj]{use_calibrations_bladj()}}.
If \code{phy} has branch lengths, the function can use the PATHd8 algorithm. See \code{\link[=use_calibrations_pathd8]{use_calibrations_pathd8()}}.
}
\section{output}{
 The output object stores the used \code{calibrations} and \code{dating_method} as
\code{attributes(output)$datelife_calibrations} and \code{attributes(output)$dating_method}.
}

