% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_na.R
\name{convert_to_na}
\alias{convert_to_na}
\alias{convert_to_na.numeric}
\alias{convert_to_na.data.frame}
\title{Convert non-missing values in a variable into missing values.}
\usage{
convert_to_na(x, ...)

\method{convert_to_na}{numeric}(x, na = NULL, verbose = TRUE, ...)

\method{convert_to_na}{data.frame}(x, na = NULL, select = NULL, exclude = NULL, verbose = TRUE, ...)
}
\arguments{
\item{x}{A vector, factor or a data frame.}

\item{...}{Not used.}

\item{na}{Numeric or character vector (or a list of numeric and character
vectors) with values that should be converted to \code{NA}.}

\item{verbose}{Toggle warnings.}

\item{select}{Character vector of column names. If \code{NULL} (the default), all
variables will be selected.}

\item{exclude}{Character vector of column names to be excluded from selection.}
}
\value{
\code{x}, where all values in \code{na} are converted to \code{NA}.
}
\description{
Convert non-missing values in a variable into missing values.
}
\examples{
x <- sample(1:6, size = 30, replace = TRUE)
x
# values 4 and 5 to NA
convert_to_na(x, na = 4:5)

# data frames
set.seed(123)
x <- data.frame(
  a = sample(1:6, size = 20, replace = TRUE),
  b = sample(letters[1:6], size = 20, replace = TRUE),
  c = sample(c(30:33, 99), size = 20, replace = TRUE)
)
# for all numerics, convert 5 to NA. Character/factor will be ignored.
convert_to_na(x, na = 5)

# for numerics, 5 to NA, for character/factor, "f" to NA
convert_to_na(x, na = list(6, "f"))

# select specific variables
convert_to_na(x, select = c("a", "b"), na = list(6, "f"))
}
