% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsorize.R
\name{winsorize}
\alias{winsorize}
\alias{winsorize.numeric}
\title{Winsorize data}
\usage{
winsorize(data, ...)

\method{winsorize}{numeric}(data, threshold = 0.2, verbose = TRUE, ...)
}
\arguments{
\item{data}{Dataframe or vector.}

\item{...}{Currently not used.}

\item{threshold}{The amount of winsorization.}

\item{verbose}{Toggle warnings.}
}
\value{
A dataframe with winsorized columns or a winsorized vector.
}
\description{
Winsorize data
}
\details{
Winsorizing or winsorization is the transformation of statistics by limiting
extreme values in the statistical data to reduce the effect of possibly
spurious outliers. The distribution of many statistics can be heavily
influenced by outliers. A typical strategy is to set all outliers (values
beyond a certain threshold) to a specified percentile of the data; for
example, a 90\\% winsorization would see all data below the 5th percentile set
to the 5th percentile, and data above the 95th percentile set to the 95th
percentile. Winsorized estimators are usually more robust to outliers than
their more standard forms.
}
\examples{
winsorize(iris$Sepal.Length, threshold = 0.2)
winsorize(iris, threshold = 0.2)
}
