% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/options.R
\name{getOpt}
\alias{default.options}
\alias{getOpt}
\title{Retrieves package options}
\usage{
getOpt(x)

default.options()
}
\arguments{
\item{x}{Option to retrieve.}
}
\description{
The dataview package contains a number of option for tailoring its
behaviour. These options are stored as a named list in a single global
varible named "dataview". To overwrite an option fetch the default values
with \code{default.options}, modify the returned results and set it back as
in the example below.
}
\details{
Below is a description of the available options,
but to understand how they work it is probably easier to directly study the
return value of \code{default.options}.
\describe{
    \item{\code{align}}{Column alignment, left or right.}
    \item{\code{columns}}{A named list with columns to use in \code{\link{whos}}.
        The \code{object} element should be a named list of functions to be
        applied on each object that is to be queried.
        The \code{envir} element should be a named list of functions to be
        applied on the object or environment on which \code{\link{whos}} is
        called together with its "accessors", which are object names
        (for environments) or named indices (for everything else).
        All functions should return a vector of values that can be used as
        a \code{\link{data.table}} column.}
    \item{\code{print}}{A named list of custom print functions.
        By default each column of a \code{\link{whos}} object
        is printed in a similar way as \code{\link{data.table}} or
        \code{\link{data.frame}}. If you wish to override this behaviour for
        a given column, please supply a named print function here.
        The function will be given the column as returned by the corresponding
        column function above, and should produce a character vector.}
    \item{\code{summary}}{A list of named summary functions.
        These are fed a column and should return a single value.}
}
}
\examples{
# This shows how to modify a column presented by whos.
# The new function only reports the size of non-S4 objects
# to improve execution time.
opt <- default.options()
opt$columns$bytes <- function(x) if(isS4(x)) NA else object.size(x)
options(dataview = opt)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

