% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SWORD_files.R
\name{delete_file}
\alias{delete_file}
\title{Delete file (SWORD)}
\usage{
delete_file(id, key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"), ...)
}
\arguments{
\item{id}{A file ID, possibly returned by \code{\link{add_file}}, or a complete \dQuote{edit-media/file} URL.}

\item{key}{A character string specifying a Dataverse server API key. If one is not specified, functions calling authenticated API endpoints will fail. Keys can be specified atomically or globally using \code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server. There are multiple Dataverse installations, but the defaults is to use the Harvard Dataverse. This can be modified atomically or globally using \code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.example.com")}.}

\item{...}{Additional arguments passed to an HTTP request function, such as \code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or \code{\link[httr]{DELETE}}.}
}
\value{
If successful, a logical \code{TRUE}, else possibly some information.
}
\description{
Delete a file from a SWORD (possibly unpublished) dataset
}
\details{
This function is used to delete a file from a dataset by its file ID. It is part of the SWORD API, which is used to upload data to a Dataverse server.
}
\examples{
\dontrun{
# retrieve your service document
d <- service_document()

# create a list of metadata
metadat <- list(title = "My Study",
                creator = "Doe, John",
                description = "An example study")

# create the dataset
dat <- initiate_sword_dataset("mydataverse", body = metadat)

# add files to dataset
tmp <- tempfile()
write.csv(iris, file = tmp)
f <- add_file(dat, file = tmp)

# delete a file
ds <- dataset_statement(dat)
delete_file(ds$files[[1]]$id

# delete a dataset
delete_dataset(dat)
}
}
\seealso{
Managing a Dataverse: \code{\link{publish_dataverse}}; Managing a dataset: \code{\link{dataset_atom}}, \code{\link{list_datasets}}, \code{\link{create_dataset}}, \code{\link{delete_dataset}}, \code{\link{publish_dataset}}; Managing files within a dataset: \code{\link{add_file}}, \code{\link{delete_file}}
}
