% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_metadata.R
\name{set_study_oid}
\alias{set_study_oid}
\alias{set_metadata_version}
\alias{set_metadata_ref}
\title{Set data metadata parameters}
\usage{
set_study_oid(x, study, ...)

set_metadata_version(x, metadata_version, ...)

set_metadata_ref(x, metadata_ref)
}
\arguments{
\item{x}{data metadata or datasetjson object}

\item{study}{Study OID value}

\item{...}{Additional parameters}

\item{metadata_version}{Metadata version OID value}

\item{metadata_ref}{Metadata reference (i.e. path to Define.xml)}
}
\value{
A datasetjson or data_metadata object
}
\description{
This set of functions
}
\examples{
data_meta <- data_metadata()
data_meta_updated <- set_metadata_ref(data_meta, "some/define.xml")
data_meta_updated <- set_metadata_version(data_meta_updated, "MDV.MSGv2.0.SDTMIG.3.3.SDTM.1.7")
data_meta_updated <- set_study_oid(data_meta_updated, "SOMESTUDY")
}
\concept{Data metadata setters}
