% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_metadata.R
\name{set_source_system}
\alias{set_source_system}
\alias{set_originator}
\alias{set_file_oid}
\alias{set_data_type}
\title{Set source system information}
\usage{
set_source_system(x, sys, sys_version)

set_originator(x, originator)

set_file_oid(x, file_oid)

set_data_type(x, data_type = c("clinicalData", "referenceData"))
}
\arguments{
\item{x}{datasetjson object}

\item{sys}{sourceSystem parameter, defined as "The computer system or
database management system that is the source of the information in this
file."}

\item{sys_version}{sourceSystemVersion, defined as "The version of the
sourceSystem"}

\item{originator}{originator parameter, defined as "The organization that
generated the Dataset-JSON file."}

\item{file_oid}{fileOID parameter, defined as "A unique identifier for this
file."}

\item{data_type}{Type of data being written. clinicalData for subject level
data, and referenceData for non-subject level data (i.e. TDMs, Associated
Persons)}
}
\value{
datasetjson or file_metadata object
}
\description{
Set information about the source system used to generate the Dataset JSON
object.
}
\examples{
file_meta <- file_metadata()

file_meta_updated <- set_file_oid(file_meta, "/some/path")
file_meta_updated <- set_originator(file_meta_updated, "Some Org")
file_meta_updated <- set_source_system(file_meta_updated, "source system", "1.0")
}
\concept{File Metadata Setters}
