% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibentry.R
\name{bibentry_dataset}
\alias{bibentry_dataset}
\title{Create a bibentry for a dataset}
\usage{
bibentry_dataset(ds)
}
\arguments{
\item{ds}{A data.frame or inherited tibble, data.frame, or a structured list.}
}
\value{
A bibentry object for the \code{ds} dataset.
}
\description{
Create a bibentry for a dataset
}
\examples{
my_dataset <- dataset (
    x = data.frame (time = rep(c(2019:2022),2),
                    geo = c(rep("NL",4), rep("BE",4)),
                    value = c(1,3,2,4,2,3,1,5),
                    unit = rep("NR",8),
                    freq = rep("A",8)),
    Dimensions = c(1,2),
    Measures = 3,
    Attributes = c(4,5),
    sdmx_attributes = c("time", "freq"),
    Title = "Example dataset",
    Creator = person("Jane", "Doe"),
    Publisher = "Publishing Co.",
    Issued = as.Date("2022-07-14")
)

bibentry(my_dataset)
utils::toBibtex(bibentry_dataset(my_dataset))
}
\concept{citation functions}
