% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelDeployment.R
\name{GetModelDeploymentActionLog}
\alias{GetModelDeploymentActionLog}
\title{Retrieve an action log for a model deployment.}
\usage{
GetModelDeploymentActionLog(modelDeploymentId, limit = NULL, offset = NULL)
}
\arguments{
\item{modelDeploymentId}{character. ID of the model deployment to retrieve.}

\item{limit}{integer. At most this many results are returned. Defaults to no limit.}

\item{offset}{integer. This many results will be skipped. Defaults to 0.}
}
\value{
dataRobotModelDeploymentActionLog object containing the following information:
\itemize{
  \item action character. The action taken. One of either "deployed" or "created".
  \item performedBy list. A list detailing information about the user taking the action.
    Contains the following:
    \itemize{
      \item username character. The username of the user taking the action.
      \item firstName character. The first name of that user.
      \item lastName character. The last name of that user.
    }
 \item performedAt datetime. The date and time the action was performed, in ISO-8601 format.
}
}
\description{
Retrieve an action log for a model deployment.
}
\examples{
\dontrun{
  modelDeploymentId <- "59a5af20c80891534e3c2bde"
  serviceHealth <- GetModelDeploymentServiceStatistics(modelDeploymentId)
  serviceHealth2 <- GetModelDeploymentServiceStatistics(modelDeploymentId,
}
}
