% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetModelJobs.R
\name{GetModelJob}
\alias{GetModelJob}
\title{Request information about a single model job}
\usage{
GetModelJob(project, modelJobId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelJobId}{Character string specifying the job id}
}
\value{
list with following elements:
\itemize{
  \item status. Model job status; an element of JobStatus, e.g. JobStatus$Queue.
  \item processes. List of character vectors describing any preprocessing applied.
  \item projectId. Character string giving the unique identifier for the project.
  \item samplePct. Numeric: the percentage of the dataset used for model building.
  \item modelType. Character string specifying the model this job builds.
  \item modelCategory. Character string: what kind of model this is - 'prime' for DataRobot Prime
    models, 'blend' for blender models, and 'model' for other models.
  \item featurelistId. Character string: id of the featurelist used in fitting the model.
  \item blueprintId. Character string: id of the DataRobot blueprint on which the model is based.
  \item modelJobId. Character: id of the job.
}
}
\description{
Request information about a single model job
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- GetModelJobs(project)
  job <- initialJobs[[1]]
  modelJobId <- job$modelJobId
  GetModelJob(projectId, modelJobId)
}
}
