% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{GetFrozenModelFromJobId}
\alias{GetFrozenModelFromJobId}
\title{Retrieve a frozen model defined by modelJobId}
\usage{
GetFrozenModelFromJobId(project, modelJobId, maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelJobId}{integer. The integer returned by either \code{RequestNewModel}
or \code{RequestSampleSizeUpdate}.}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the model job to
complete.}
}
\value{
An S3 object of class 'dataRobotFrozenModel' summarizing all
available information about the model.
}
\description{
The function RequestFrozenModel
initiate the creation of frozen models in a DataRobot project.
RequestFrozenModel function submit requests to the DataRobot modeling
engine and return an integer-valued modelJobId.  The
GetFrozenModelFromJobId function polls the modeling engine until
the model has been built or a specified time limit is exceeded,
returning an S3 object of class 'dataRobotFrozenModel' when the model
is available.
}
\details{
Motivation for this function is the fact that some models -
e.g., very complex machine learning models fit to large datasets -
may take a long time to complete.  Splitting the model creation
request from model retrieval in these cases allows the user to
perform other interactive R session tasks between the time the
model creation/update request is made and the time the final
model is available.

GetModelFromJobId also can be used to retrieve some information about
frozen model, however then some frozen specific information (parentModelId)
will not be returned.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- GetModelJobs(project)
  job <- initialJobs[[1]]
  modelJobId <- job$modelJobId
  GetModelJobFromJobId(projectId, modelJobId)
}
}
