% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeleteModelJob.R
\name{DeleteModelJob}
\alias{DeleteModelJob}
\title{Delete a model job from the modeling queue}
\usage{
DeleteModelJob(project, modelJobId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId
with this identifier.}

\item{modelJobId}{integer. Identifier for the modeling job to be
deleted; can be obtained from the results returned by the function
GetModelJobs.}
}
\description{
This function deletes the modeling job specified by modelJobId from
the DataRobot modeling queue.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- GetModelJobs(project)
  job <- initialJobs[[1]]
  modelJobId <- job$modelJobId
  DeleteModelJob(projectId, modelJobId)
}
}
