% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReasonCodes.R
\name{GetReasonCodesInitializationFromJobId}
\alias{GetReasonCodesInitializationFromJobId}
\title{Retrieve the reason codes initialization for a model using jobId}
\usage{
GetReasonCodesInitializationFromJobId(project, jobId, maxWait = 600)
}
\arguments{
\item{project}{Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this identifier.}

\item{jobId}{Unique integer identifier (return for example by RequestReasonCodesInitialization)}

\item{maxWait}{Integer, The maximum time (in seconds) to wait for the model job to complete}
}
\value{
A named list which contains:
\describe{
  \item{projectId}{Character id of the project the feature belonges to}
  \item{modelId}{Character string giving the unique alphanumeric model identifier}
  \item{reasonCodesSample}{list which contains sample of reason codes. 
 Each element of the list is information about reason codes for one data row. For more information see GetReasonCodesRows}
 }
}
\description{
Reason codes initializations are a prerequisite for computing reason codes, and include
a sample what the computed reason codes for a prediction dataset would look like.
}
