% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetupProject.R
\name{SetupProject}
\alias{SetupProject}
\title{Function to set up a new DataRobot project}
\usage{
SetupProject(dataSource, projectName = NULL, maxWait = 60 * 60)
}
\arguments{
\item{dataSource}{Either (a) the name of a CSV file or (b) a dataframe;
in either case, this parameter identifies the source of the data from which
all project models will be built.  See Details.}

\item{projectName}{Optional character string specifying a project name.}

\item{maxWait}{The maximum time to wait for each of two steps: (1) The initial project creation
request, and (2) data processing that occurs after receiving the response to this initial
request.}
}
\value{
This function returns a list with the following four components:
\describe{
  \item{projectName}{The name assigned to the DataRobot project}
  \item{projectId}{The unique alphanumeric project identifier for this DataRobot project}
  \item{fileName}{The name of the CSV modeling file uploaded for this project}
  \item{created}{Character string containing the time and date of project creation}
}
}
\description{
This function uploads a modeling dataset defined by the dataSource parameter
and allows specification of the optional project name projectName. The
dataSource parameter can be either the name of a CSV file or a dataframe;
in the latter case, it is saved as a CSV file whose name is described in
the Details section. This function returns the projectName specified in the
calling sequence, the unique alphanumeric identifier projectId for the new
project, the name of the modeling dataset uploaded to create this project,
and the project creation time and date.
}
\details{
The DataRobot modeling engine requires a CSV file containing the data to be
used in fitting models, and this has been implemented here in two ways.
The first and simpler is to specify dataSource as the name of this CSV file,
but for the convenience of those who wish to work with dataframes, this
function also provides the option of specifying a dataframe, which is then
written to a CSV file and uploaded to the DataRobot server. In this case, the
file name is either specified directly by the user through the saveFile
parameter, or indirectly from the name of the dataSource dataframe if
saveFile = NULL (the default).  In this second case, the file name consists
of the name of the dataSource dataframe with the string csvExtension appended.
}

