% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestNewModel.R
\name{RequestNewModel}
\alias{RequestNewModel}
\title{Adds a new model of type specified by blueprint to a DataRobot project}
\usage{
RequestNewModel(project, blueprint, featurelist = NULL, samplePct = NULL,
  scoringType = NULL)
}
\arguments{
\item{project}{Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this identifier.}

\item{blueprint}{A list with at least the following two elements:
blueprintId and projectId.  Note that the individual elements of the
list returned by GetRecommendedBlueprints are admissible values for
this parameter.}

\item{featurelist}{A list that contains the element featurelistId that
specifies the featurelist to be used in building the model; if not
specified (i.e., for the default value NULL), the project default
(Informative Features) is used.}

\item{samplePct}{Numeric, specifying the percentage of the training
dataset to be used in building the new model; if not specified
(i.e., for the default value NULL), the maxTrainPct value for the
project is used.}

\item{scoringType}{Character string specifying the scoring type;
default is validation set scoring, but cross-validation averaging
is also possible.}
}
\value{
An integer value that can be used as the modelJobId parameter
in subsequent calls to the GetModelFromJobId function.
}
\description{
This function requests the creation of a new model in the DataRobot
modeling project defined by the project parameter.  The function also
allows the user to specify alternatives to the project default for
featurelist, samplePct, and scoringType.  This function returns an
integer modelJobId value, which can be used by the GetModelFromJobId
function to return the full model object.
}
\details{
Motivation for this function is the fact that some models - e.g., very
complex machine learning models fit to large datasets - may take a long
time to complete.  Splitting the model creation request from model
retrieval in these cases allows the user to perform other interactive R
session tasks between the time the model creation/update request is made
and the time the final model is available.
}

