% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureAssociations.R
\name{GetFeatureAssociationMatrixDetails}
\alias{GetFeatureAssociationMatrixDetails}
\title{Get a sample of the actual values used to measure the association between a pair of features.}
\usage{
GetFeatureAssociationMatrixDetails(project, feature1, feature2)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{feature1}{character. The name of the first feature of interest.}

\item{feature2}{character. The name of the second feature of interest.}
}
\value{
A list with the following info:
\itemize{
   \item features list. The names of `feature1` and `feature2`.
   \item types list. The type of `feature1` and `feature2`. Will be "C" for categorical and
      "N" for numeric.
   \item values data.frame. The values of the feature associations and the relative frequency
     of the datapoints in the sample.
}
}
\description{
Get a sample of the actual values used to measure the association between a pair of features.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  GetFeatureAssociationMatrix(projectId, "SepalWidth", "SepalLength")
}
}
