% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C3FURV.R
\name{daily_out_of_range}
\alias{daily_out_of_range}
\title{Daily big errors test}
\usage{
daily_out_of_range(
  dailydata,
  meta = NULL,
  outpath,
  tmax_upper = 45,
  tmax_lower = -30,
  tmin_upper = 30,
  tmin_lower = -40,
  rr_upper = 200,
  rr_lower = 0,
  w_upper = 30,
  w_lower = 0,
  dd_upper = 360,
  dd_lower = 0,
  sc_upper = 100,
  sc_lower = 0,
  sd_upper = 200,
  sd_lower = 0,
  fs_upper = 100,
  fs_lower = 0
)
}
\arguments{
\item{dailydata}{A character string giving the path of the input file,
or a 5-column matrix with following columns: variable code, year, month,
day, and the daily value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{dailydata} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}

\item{tmax_upper}{is the tx maximum threshold in degrees Celsius.
By default, tmax_upper = 45 C.}

\item{tmax_lower}{is the tx minimum threshold in degrees Celsius.
By default, tmax_lower = -30 C.}

\item{tmin_upper}{is the tn maximum threshold in degrees Celsius.
By default, tmin_upper = 30 C.}

\item{tmin_lower}{is the tn minimum threshold in degrees Celsius.
By default, tmin_lower = -40 C.}

\item{rr_upper}{is the rr maximum threshold in millimetres.
By default, rr_upper = 200 mm.}

\item{rr_lower}{is the rr minimum threshold in millimetres.
By default, rr_lower = 0 mm.}

\item{w_upper}{is the w maximum threshold in metres per second.
By default, w_upper = 30 m/s.}

\item{w_lower}{is the w mimumum threshold in metres per second.
By default, w_lower = 0 m/s.}

\item{dd_upper}{is the dd maximum threshold in degrees North.
By default, dd_upper = 360.}

\item{dd_lower}{is the dd minimum threshold in degrees North.
By default, dd_lower = 0.}

\item{sc_upper}{is the sc maximum threshold in percent.
By default, sc_upper = 100\%.}

\item{sc_lower}{is the sc minimum threshold in percent.
By default, sc_lower = 0\%.}

\item{sd_upper}{is the sd maximum threshold in centimetres.
By default, sd_upper = 200 cm.}

\item{sd_lower}{is the sd minimum threshold in centimetres.
By default, sd_lower = 0 cm.}

\item{fs_upper}{is the fs maximum threshold in centimetres.
By default, fs_upper = 100 cm.}

\item{fs_lower}{is the fs minimum threshold in centimetres.
By default, fs_lower = 0 cm.}
}
\description{
Find the daily maximum, minimum, precipitation, mean wind direction,
mean wind speed, snow cover and snow depth that exceed thresholds selected by the
user. The output is a list with the days in which Tx, Tn, rr, dd, w, sc, sd
or fs exceeds some threshold.
}
\details{
The input file must follow the Copernicus Station Exchange Format (SEF).
}
\examples{
daily_out_of_range(Rosario$Tn, Meta$Tn, outpath = tempdir(), tmin_upper = 25)

}
\author{
Alba Gilabert, Yuri Brugnara
}
