% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_normalize_value_labels.R
\name{util_normalize_value_labels}
\alias{util_normalize_value_labels}
\title{Convert \code{VALUE_LABELS} to separate tables}
\usage{
util_normalize_value_labels(
  meta_data = "item_level",
  max_value_label_len = getOption("dataquieR.MAX_VALUE_LABEL_LEN",
    dataquieR.MAX_VALUE_LABEL_LEN_default)
)
}
\arguments{
\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{max_value_label_len}{\link{integer} maximum length for value labels}
}
\value{
\link{data.frame} metadata with \code{VALUE_LABEL_TABLE} instead of
\code{VALUE_LABELS} (or none of these, if absent)
}
\description{
Convert \code{VALUE_LABELS} to separate tables
}
\examples{
\dontrun{
prep_purge_data_frame_cache()
prep_load_workbook_like_file("meta_data_v2")
util_normalize_value_labels()
prep_add_data_frames(test_labs =
  tibble::tribble(~ CODE_VALUE, ~ CODE_LABEL, 17L, "Test", 19L, "Test",
    17L, "TestX"))
il <- prep_get_data_frame("item_level")
if (!VALUE_LABEL_TABLE \%in\% colnames(il)) {
  il$VALUE_LABEL_TABLE <- NA_character_
}
il$VALUE_LABEL_TABLE[[1]] <- "test_labs"
il$VALUE_LABELS[[1]] <- "17 = TestY"
prep_add_data_frames(item_level = il)
util_normalize_value_labels()
}

}
\keyword{internal}
