% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_int_breaks_rounded.R
\name{util_int_breaks_rounded}
\alias{util_int_breaks_rounded}
\title{Integer breaks for \code{ggplot2}}
\usage{
util_int_breaks_rounded(x, n = 5)
}
\arguments{
\item{x}{the values}

\item{n}{integer giving the desired number of intervals. Non-integer values are rounded down.}
}
\value{
breaks suitable for \verb{scale_*_continuous}' \code{breaks} argument
}
\description{
creates integer-only breaks
}
\examples{
\dontrun{
big_numbers1 <- data.frame(x = 1:5, y = c(0:1, 0, 1, 0))
big_numbers2 <- data.frame(x = 1:5, y = c(0:1, 0, 1, 0) + 1000000)

big_numbers_plot1 <- ggplot(big_numbers1, aes(x = x, y = y)) +
  geom_point()

big_numbers_plot2 <- ggplot(big_numbers2, aes(x = x, y = y)) +
  geom_point()

big_numbers_plot1 + scale_y_continuous()
big_numbers_plot1 + scale_y_continuous(breaks = util_int_breaks_rounded)

big_numbers_plot2 + scale_y_continuous()
big_numbers_plot2 + scale_y_continuous(breaks = util_int_breaks_rounded)
}

}
\seealso{
\href{https://stackoverflow.com/a/57086284}{StackOverflow}
}
\author{
\href{https://stackoverflow.com/users/2738526/sarah}{Sarah}
}
\keyword{internal}
