% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_end_digits.R
\name{acc_end_digits}
\alias{acc_end_digits}
\title{Extension of \link{acc_shape_or_scale} to examine uniform distributions of
end digits}
\usage{
acc_end_digits(
  resp_vars = NULL,
  study_data,
  label_col,
  item_level = "item_level",
  meta_data = item_level,
  meta_data_v2
)
}
\arguments{
\item{resp_vars}{\link{variable} the names of the measurement variables,
mandatory}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}
}
\value{
a \link{list} with:
\itemize{
\item \code{SummaryTable}: \link{data.frame} with the columns \code{Variables} and \code{FLG_acc_ud_shape}
\item \code{SummaryPlot}: ggplot2 distribution plot comparing expected
with observed distribution
}
}
\description{
This implementation contrasts the empirical distribution of a measurement
variables against assumed distributions. The approach is adapted from the
idea of rootograms (Tukey (1977)) which is also applicable for count data
(Kleiber and Zeileis (2016)).

\link{Indicator}
}
\section{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item This implementation is restricted to data of type float or integer.
\item Missing codes are removed from resp_vars (if defined in the metadata)
\item The user must specify the column of the metadata containing probability
distribution (currently only: normal, uniform, gamma)
\item Parameters of each distribution can be estimated from the data or are
specified by the user
\item A histogram-like plot contrasts the empirical vs. the technical
distribution
}
}

\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_acc_impl_end_digits.html}{Online Documentation}
}
