% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_get_code_list.R
\name{util_get_code_list}
\alias{util_get_code_list}
\title{Fetch a missing code list from the metadata}
\usage{
util_get_code_list(
  x,
  code_name,
  split_char = SPLIT_CHAR,
  mdf,
  label_col = VAR_NAMES,
  warning_if_no_list = TRUE,
  warning_if_unsuitable_list = TRUE
)
}
\arguments{
\item{x}{\link{variable} the name of the variable to retrieve code lists for.
only one variable at a time is supported, \emph{not}
vectorized!!}

\item{code_name}{\link{variable attribute} \link{JUMP_LIST} or \link{MISSING_LIST}:
Which codes to retrieve.}

\item{split_char}{\link{character} len = 1. Character(s) used to separate
different codes in the metadata, usually \code{|},
as in \code{99999|99998|99997}.}

\item{mdf}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{warning_if_no_list}{\link{logical} len = 1. If \code{TRUE}, a warning is
displayed, if no missing
codes are available for a
variable.}

\item{warning_if_unsuitable_list}{\link{logical} len = 1. If \code{TRUE}, a warning is
displayed, if missing
codes do not match with a
variable' data type.}
}
\value{
\link{numeric} vector of missing codes.
}
\description{
get missing codes from metadata (e.g. \link{MISSING_LIST} or \link{JUMP_LIST})
}
\seealso{
Other missing_functions: 
\code{\link{util_all_intro_vars_for_rv}()},
\code{\link{util_count_expected_observations}()},
\code{\link{util_filter_missing_list_table_for_rv}()},
\code{\link{util_is_na_0_empty_or_false}()},
\code{\link{util_observation_expected}()},
\code{\link{util_remove_empty_rows}()},
\code{\link{util_replace_codes_by_NA}()}
}
\concept{metadata_management}
\concept{missing_functions}
\keyword{internal}
