% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_correct_variable_use.R
\name{util_correct_variable_use}
\alias{util_correct_variable_use}
\alias{util_correct_variable_use2}
\title{Check referred variables}
\usage{
util_correct_variable_use(
  arg_name,
  allow_na,
  allow_more_than_one,
  allow_null,
  allow_all_obs_na,
  allow_any_obs_na,
  min_distinct_values,
  need_type,
  role = "",
  overwrite = TRUE,
  do_not_stop = FALSE,
  remove_not_found = TRUE
)

util_correct_variable_use2(
  arg_name,
  allow_na,
  allow_more_than_one,
  allow_null,
  allow_all_obs_na,
  allow_any_obs_na,
  min_distinct_values,
  need_type,
  role = arg_name,
  overwrite = TRUE,
  do_not_stop = FALSE,
  remove_not_found = TRUE
)
}
\arguments{
\item{arg_name}{\link{character} Name of a function argument of the caller
of \link{util_correct_variable_use}}

\item{allow_na}{\link{logical} default = FALSE. allow NAs in the variable names
argument given in \code{arg_name}}

\item{allow_more_than_one}{\link{logical} default = FALSE. allow more than one
variable names in \code{arg_name}}

\item{allow_null}{\link{logical} default = FALSE. allow an empty variable name
vector in the argument \code{arg_name}}

\item{allow_all_obs_na}{\link{logical} default = TRUE. check observations for not
being all \code{NA}}

\item{allow_any_obs_na}{\link{logical} default = TRUE. check observations for
being complete without any \code{NA}}

\item{min_distinct_values}{\link{integer} Minimum number of distinct observed
values of a study variable}

\item{need_type}{\link{character} if not \code{NA}, variables must be of data type
\code{need_type} according to the metadata,
can be a pipe (\code{|}) separated list of
allowed data types. Use \code{!} to exclude
a type. See \link{DATA_TYPES} for the
predefined variable types of the
\code{dataquieR} concept.}

\item{role}{\link{character} variable-argument role. Set different defaults for
all \code{allow}-arguments and \code{need_type} of
this \code{util_correct_variable_use.}. If given, it
defines the intended use
of the verified argument. For typical arguments and
typical use cases, roles
are predefined in \link{.variable_arg_roles}.
The role's defaults can be overwritten by the
arguments. If \code{role} is "" (default),
the standards are \code{allow_na = FALSE},
\code{allow_more_than_one = FALSE}, \code{allow_null = FALSE},
\code{allow_all_obs_na = TRUE}, \code{allow_any_obs_na = TRUE},
and \code{need_type = NA}.
Use \link{util_correct_variable_use2} for using the
\code{arg_name} as default for \code{role}.
See \link{.variable_arg_roles} for currently available
variable-argument roles.}

\item{overwrite}{\link{logical} overwrite vector of variable names
to match the labels given in \code{label_col}.}

\item{do_not_stop}{\link{logical} do not throw an error, if one of the variables
violates \code{allow_all_obs_na}, \code{allow_any_obs_na} or
\code{min_distinct_values}. Instead, the variable will be
removed from \code{arg_name} in the parent environment
with a warning. This is helpful for functions which
work with multiple variables.}

\item{remove_not_found}{TODO: Not yet implemented}
}
\description{
This function operates in the environment of its caller
(using \link{eval.parent}, similar to \href{https://www.programiz.com/c-programming/c-preprocessor-macros#example-define}{Function like C-Preprocessor-Macros}
).
Different from the other utility function that work
in the caller's environment (\link{util_prepare_dataframes}), It has no side
effects except that the argument
of the calling function specified in \code{arg_name} is normalized (set to its
default or a general default if missing, variable names being all white
space replaced by NAs).
It expects two objects in the caller's environment: \code{ds1} and \code{meta_data}.
\code{meta_data} is the metadata data frame and \code{ds1} is produced by a preceding
call of \link{util_prepare_dataframes} using \code{meta_data} and \code{study_data}.
}
\details{
\link{util_correct_variable_use} and \link{util_correct_variable_use2} differ only in
the default of the argument \code{role}.

\link{util_correct_variable_use} and \link{util_correct_variable_use2} put strong
effort on producing compressible
error messages to the caller's caller (who is typically an end user of
a \code{dataquieR} function).

The function ensures, that a specified argument of its caller that refers
variable names
(one or more as character vector) matches some expectations.

This function accesses the caller's environment!
}
\seealso{
\link{.variable_arg_roles}
}
