test_that("prep_study2meta works", {
  expect_error(
    prep_study2meta(cars, convert_factors = 1:3),
    regexp = "Argument.+convert_factors.+must be logical.1."
  )

  meta_data <- prep_study2meta(iris, convert_factors = TRUE)
  expect_equal(
    meta_data,
    list(
      MetaData = structure(
        list(
          VAR_NAMES = c(
            "Sepal.Length",
            "Sepal.Width",
            "Petal.Length",
            "Petal.Width",
            "Species"
          ),
          DATA_TYPE = c("float",  "float", "float", "float", "string"),
          VALUE_LABELS = c(NA, NA,  NA, NA, "1 = setosa | 2 = versicolor | 3 = virginica"),
          MISSING_LIST = c("",  "", "", "", ""),
          DETECTION_LIMITS = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          ),
          SOFT_LIMITS = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          ),
          CONTRADICTIONS = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          ),
          DISTRIBUTION = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          ),
          DECIMALS = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          ),
          DATA_ENTRY_TYPE = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          ),
          VARIABLE_ROLE = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          ),
          VARIABLE_ORDER = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          ),
          LONG_LABEL = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          ),
          recode = c(
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_,
            NA_character_
          )
        ),
        class = "data.frame",
        row.names = c(
          "Sepal.Length",
          "Sepal.Width",
          "Petal.Length",
          "Petal.Width",
          "Species"
        )
      ),
      ModifiedStudyData = structure(
        list(
          Sepal.Length = c(
            5.1,
            4.9,
            4.7,
            4.6,
            5,
            5.4,
            4.6,
            5,
            4.4,
            4.9,
            5.4,
            4.8,
            4.8,
            4.3,
            5.8,
            5.7,
            5.4,
            5.1,
            5.7,
            5.1,
            5.4,
            5.1,
            4.6,
            5.1,
            4.8,
            5,
            5,
            5.2,
            5.2,
            4.7,
            4.8,
            5.4,
            5.2,
            5.5,
            4.9,
            5,
            5.5,
            4.9,
            4.4,
            5.1,
            5,
            4.5,
            4.4,
            5,
            5.1,
            4.8,
            5.1,
            4.6,
            5.3,
            5,
            7,
            6.4,
            6.9,
            5.5,
            6.5,
            5.7,
            6.3,
            4.9,
            6.6,
            5.2,
            5,
            5.9,
            6,
            6.1,
            5.6,
            6.7,
            5.6,
            5.8,
            6.2,
            5.6,
            5.9,
            6.1,
            6.3,
            6.1,
            6.4,
            6.6,
            6.8,
            6.7,
            6,
            5.7,
            5.5,
            5.5,
            5.8,
            6,
            5.4,
            6,
            6.7,
            6.3,
            5.6,
            5.5,
            5.5,
            6.1,
            5.8,
            5,
            5.6,
            5.7,
            5.7,
            6.2,
            5.1,
            5.7,
            6.3,
            5.8,
            7.1,
            6.3,
            6.5,
            7.6,
            4.9,
            7.3,
            6.7,
            7.2,
            6.5,
            6.4,
            6.8,
            5.7,
            5.8,
            6.4,
            6.5,
            7.7,
            7.7,
            6,
            6.9,
            5.6,
            7.7,
            6.3,
            6.7,
            7.2,
            6.2,
            6.1,
            6.4,
            7.2,
            7.4,
            7.9,
            6.4,
            6.3,
            6.1,
            7.7,
            6.3,
            6.4,
            6,
            6.9,
            6.7,
            6.9,
            5.8,
            6.8,
            6.7,
            6.7,
            6.3,
            6.5,
            6.2,
            5.9
          ),
          Sepal.Width = c(
            3.5,
            3,
            3.2,
            3.1,
            3.6,
            3.9,
            3.4,
            3.4,
            2.9,
            3.1,
            3.7,
            3.4,
            3,
            3,
            4,
            4.4,
            3.9,
            3.5,
            3.8,
            3.8,
            3.4,
            3.7,
            3.6,
            3.3,
            3.4,
            3,
            3.4,
            3.5,
            3.4,
            3.2,
            3.1,
            3.4,
            4.1,
            4.2,
            3.1,
            3.2,
            3.5,
            3.6,
            3,
            3.4,
            3.5,
            2.3,
            3.2,
            3.5,
            3.8,
            3,
            3.8,
            3.2,
            3.7,
            3.3,
            3.2,
            3.2,
            3.1,
            2.3,
            2.8,
            2.8,
            3.3,
            2.4,
            2.9,
            2.7,
            2,
            3,
            2.2,
            2.9,
            2.9,
            3.1,
            3,
            2.7,
            2.2,
            2.5,
            3.2,
            2.8,
            2.5,
            2.8,
            2.9,
            3,
            2.8,
            3,
            2.9,
            2.6,
            2.4,
            2.4,
            2.7,
            2.7,
            3,
            3.4,
            3.1,
            2.3,
            3,
            2.5,
            2.6,
            3,
            2.6,
            2.3,
            2.7,
            3,
            2.9,
            2.9,
            2.5,
            2.8,
            3.3,
            2.7,
            3,
            2.9,
            3,
            3,
            2.5,
            2.9,
            2.5,
            3.6,
            3.2,
            2.7,
            3,
            2.5,
            2.8,
            3.2,
            3,
            3.8,
            2.6,
            2.2,
            3.2,
            2.8,
            2.8,
            2.7,
            3.3,
            3.2,
            2.8,
            3,
            2.8,
            3,
            2.8,
            3.8,
            2.8,
            2.8,
            2.6,
            3,
            3.4,
            3.1,
            3,
            3.1,
            3.1,
            3.1,
            2.7,
            3.2,
            3.3,
            3,
            2.5,
            3,
            3.4,
            3
          ),
          Petal.Length = c(
            1.4,
            1.4,
            1.3,
            1.5,
            1.4,
            1.7,
            1.4,
            1.5,
            1.4,
            1.5,
            1.5,
            1.6,
            1.4,
            1.1,
            1.2,
            1.5,
            1.3,
            1.4,
            1.7,
            1.5,
            1.7,
            1.5,
            1,
            1.7,
            1.9,
            1.6,
            1.6,
            1.5,
            1.4,
            1.6,
            1.6,
            1.5,
            1.5,
            1.4,
            1.5,
            1.2,
            1.3,
            1.4,
            1.3,
            1.5,
            1.3,
            1.3,
            1.3,
            1.6,
            1.9,
            1.4,
            1.6,
            1.4,
            1.5,
            1.4,
            4.7,
            4.5,
            4.9,
            4,
            4.6,
            4.5,
            4.7,
            3.3,
            4.6,
            3.9,
            3.5,
            4.2,
            4,
            4.7,
            3.6,
            4.4,
            4.5,
            4.1,
            4.5,
            3.9,
            4.8,
            4,
            4.9,
            4.7,
            4.3,
            4.4,
            4.8,
            5,
            4.5,
            3.5,
            3.8,
            3.7,
            3.9,
            5.1,
            4.5,
            4.5,
            4.7,
            4.4,
            4.1,
            4,
            4.4,
            4.6,
            4,
            3.3,
            4.2,
            4.2,
            4.2,
            4.3,
            3,
            4.1,
            6,
            5.1,
            5.9,
            5.6,
            5.8,
            6.6,
            4.5,
            6.3,
            5.8,
            6.1,
            5.1,
            5.3,
            5.5,
            5,
            5.1,
            5.3,
            5.5,
            6.7,
            6.9,
            5,
            5.7,
            4.9,
            6.7,
            4.9,
            5.7,
            6,
            4.8,
            4.9,
            5.6,
            5.8,
            6.1,
            6.4,
            5.6,
            5.1,
            5.6,
            6.1,
            5.6,
            5.5,
            4.8,
            5.4,
            5.6,
            5.1,
            5.1,
            5.9,
            5.7,
            5.2,
            5,
            5.2,
            5.4,
            5.1
          ),
          Petal.Width = c(
            0.2,
            0.2,
            0.2,
            0.2,
            0.2,
            0.4,
            0.3,
            0.2,
            0.2,
            0.1,
            0.2,
            0.2,
            0.1,
            0.1,
            0.2,
            0.4,
            0.4,
            0.3,
            0.3,
            0.3,
            0.2,
            0.4,
            0.2,
            0.5,
            0.2,
            0.2,
            0.4,
            0.2,
            0.2,
            0.2,
            0.2,
            0.4,
            0.1,
            0.2,
            0.2,
            0.2,
            0.2,
            0.1,
            0.2,
            0.2,
            0.3,
            0.3,
            0.2,
            0.6,
            0.4,
            0.3,
            0.2,
            0.2,
            0.2,
            0.2,
            1.4,
            1.5,
            1.5,
            1.3,
            1.5,
            1.3,
            1.6,
            1,
            1.3,
            1.4,
            1,
            1.5,
            1,
            1.4,
            1.3,
            1.4,
            1.5,
            1,
            1.5,
            1.1,
            1.8,
            1.3,
            1.5,
            1.2,
            1.3,
            1.4,
            1.4,
            1.7,
            1.5,
            1,
            1.1,
            1,
            1.2,
            1.6,
            1.5,
            1.6,
            1.5,
            1.3,      1.3, 1.3, 1.2, 1.4, 1.2, 1, 1.3, 1.2, 1.3, 1.3, 1.1, 1.3,      2.5, 1.9, 2.1, 1.8, 2.2, 2.1, 1.7, 1.8, 1.8, 2.5, 2, 1.9,      2.1, 2, 2.4, 2.3, 1.8, 2.2, 2.3, 1.5, 2.3, 2, 2, 1.8, 2.1,      1.8, 1.8, 1.8, 2.1, 1.6, 1.9, 2, 2.2, 1.5, 1.4, 2.3, 2.4,      1.8, 1.8, 2.1, 2.4, 2.3, 1.9, 2.3, 2.5, 2.3, 1.9, 2, 2.3,      1.8), Species = c(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L,      1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 2L, 2L, 2L, 2L,      2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,      2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,      2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 2L,      3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,      3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,      3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L,      3L, 3L, 3L, 3L, 3L)), row.names = c(NA, -150L), class = "data.frame")))

  meta_data <- prep_study2meta(cars)
  expect_equal(meta_data,
               data.frame(VAR_NAMES = colnames(cars),
                          DATA_TYPE = "integer",
                          MISSING_LIST = "",
                          DETECTION_LIMITS = NA_character_,
                          SOFT_LIMITS = NA_character_,
                          CONTRADICTIONS = NA_character_,
                          DISTRIBUTION = NA_character_,
                          DECIMALS = NA_character_,
                          DATA_ENTRY_TYPE = NA_character_,
                          VARIABLE_ROLE = NA_character_,
                          VARIABLE_ORDER = NA_character_,
                          LONG_LABEL = NA_character_,
                          recode = NA_character_,
                          stringsAsFactors = FALSE,
                          row.names = colnames(cars))
  )
  expect_error(prep_study2meta(42),
               regexp = "Need study data as a data frame")
  expect_error(prep_study2meta(NULL),
               regexp = "Need study data as a data frame")
  expect_error(prep_study2meta(),
               regexp = "Need study data as a data frame")
  expect_error(prep_study2meta(cars[, c()]),
               regexp = "No study variables found -- cannot proceed.")
})

test_that("prep_study2meta handles tibbles correctly", {
  skip_if_not_installed("tibble") # should never be skipped, since dplyr is a
                                  # dependency of dataquieR and dplr depends on
                                  # tibble
  meta_data <- prep_study2meta(tibble::as_tibble(cars))
  expect_equal(meta_data,
               data.frame(VAR_NAMES = colnames(cars),
                          DATA_TYPE = "integer",
                          MISSING_LIST = "",
                          DETECTION_LIMITS = NA_character_,
                          SOFT_LIMITS = NA_character_,
                          CONTRADICTIONS = NA_character_,
                          DISTRIBUTION = NA_character_,
                          DECIMALS = NA_character_,
                          DATA_ENTRY_TYPE = NA_character_,
                          VARIABLE_ROLE = NA_character_,
                          VARIABLE_ORDER = NA_character_,
                          LONG_LABEL = NA_character_,
                          recode = NA_character_,
                          stringsAsFactors = FALSE,
                          row.names = colnames(cars))
  )
  meta_data <-
    expect_warning(
      with_mock(requireNamespace = function(...) {
        return(FALSE)
      },
        prep_study2meta(tibble::as_tibble(cars))
      ),
    regexp =
      sprintf("%s",
              paste(".+study_data.+ looks like a tibble. However, the package",
                    ".+tibble.+ seems not to be available,")),
    perl = TRUE,
    all = TRUE
  )
  expect_equal(meta_data,
               data.frame(VAR_NAMES = colnames(cars),
                          DATA_TYPE = "integer",
                          MISSING_LIST = "",
                          DETECTION_LIMITS = NA_character_,
                          SOFT_LIMITS = NA_character_,
                          CONTRADICTIONS = NA_character_,
                          DISTRIBUTION = NA_character_,
                          DECIMALS = NA_character_,
                          DATA_ENTRY_TYPE = NA_character_,
                          VARIABLE_ROLE = NA_character_,
                          VARIABLE_ORDER = NA_character_,
                          LONG_LABEL = NA_character_,
                          recode = NA_character_,
                          stringsAsFactors = FALSE,
                          row.names = colnames(cars))
  )
})

test_that("prep_study2meta works on study_data", {
  load(system.file("extdata/study_data.RData", package = "dataquieR"), envir =
         environment())
  load(system.file("extdata/meta_data.RData", package = "dataquieR"), envir =
         environment())
  study_data <- study_data[, order(colnames(study_data)), FALSE]
  meta_data <- meta_data[order(meta_data$VAR_NAMES), , FALSE]
  meta_data[meta_data$LABEL %in% c("SBP_0", "DBP_0", "ARM_CIRC_0", "BSG_0"),
            DATA_TYPE] <- # values are not really float
    DATA_TYPES$INTEGER
  guessed_meta_data <- prep_study2meta(study_data)
  expect_equal(
    guessed_meta_data,
    data.frame(
      VAR_NAMES = meta_data$VAR_NAMES,
      DATA_TYPE = meta_data$DATA_TYPE,
      MISSING_LIST = c(
        "",
        "",
        "",
        "",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "99980|99988|99989",
        "",
        "99980|99988|99989|99990",
        "99980",
        "",
        "",
        "",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "",
        "",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "99980|99988|99989|99990",
        "",
        "",
        "",
        "",
        "99980|99988|99989|99990",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "",
        "99980|99988|99989|99990",
        "",
        "",
        "99980|99988|99989|99990",
        "",
        "",
        "",
        "",
        ""
      ),
      DETECTION_LIMITS = NA_character_,
      SOFT_LIMITS = NA_character_,
      CONTRADICTIONS = NA_character_,
      DISTRIBUTION = NA_character_,
      DECIMALS = NA_character_,
      DATA_ENTRY_TYPE = NA_character_,
      VARIABLE_ROLE = NA_character_,
      VARIABLE_ORDER = NA_character_,
      LONG_LABEL = NA_character_,
      recode = NA_character_,
      stringsAsFactors = FALSE,
      row.names = colnames(study_data)
    )
  )
})
