% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_item_missingness.R
\name{com_item_missingness}
\alias{com_item_missingness}
\title{Summarize missingness columnwise (in variable)}
\usage{
com_item_missingness(
  study_data,
  meta_data,
  resp_vars = NULL,
  label_col,
  show_causes = TRUE,
  cause_label_df,
  include_sysmiss = NULL,
  threshold_value,
  suppressWarnings = FALSE
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{resp_vars}{\link{variable list} the name of the measurement variables}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{show_causes}{\link{logical} if TRUE, then the distribution of missing codes
is shown}

\item{cause_label_df}{\link{data.frame} missing code table. If missing codes have
labels the respective data frame must be
specified here}

\item{include_sysmiss}{\link{logical} Optional, if TRUE system missingness (NAs)
is evaluated in the summary plot}

\item{threshold_value}{\link{numeric} from=0 to=100. a numerical value ranging
from 0-100}

\item{suppressWarnings}{\link{logical} warn about mixed missing and jump code
lists}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: data frame about item missingness per response variable
\item \code{SummaryPlot}: ggplot2 heatmap plot, if show_causes was TRUE
}
}
\description{
Item-Missingness (also referred to as item nonresponse (De Leeuw et al.
2003)) describes the missingness of single values, e.g. blanks or empty data
cells in a data set. Item-Missingness occurs for example in case a respondent
does not provide information for a certain question, a question is overlooked
by accident, a programming failure occurs or a provided answer were missed
while entering the data.
}
\section{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item Lists of missing codes and, if applicable, jump codes are selected from
the metadata
\item The no. of system missings (NA) in each variable is calculated
\item The no. of used missing codes is calculated for each variable
\item The no. of used jump codes is calculated for each variable
\item Two result dataframes (1: on the level of observations, 2: a summary for
each variable) are generated
\item \emph{OPTIONAL:} if \code{show_causes} is selected, one summary plot for all
\code{resp_vars} is provided
}
}

\seealso{
\href{https://dfg-qa.ship-med.uni-greifswald.de/VIN_com_impl_item_missingness.html}{Online Documentation}
}
