% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource.R
\name{Resource.load}
\alias{Resource.load}
\title{Instantiate \code{Resource} class}
\usage{
Resource.load(descriptor = list(), basePath = NA, strict = FALSE, dataPackage = list())
}
\arguments{
\item{descriptor}{Data resource descriptor as local path, url or object}

\item{basePath}{Base path for all relative paths}

\item{strict}{Strict flag to alter validation behavior. Setting it to \code{TRUE} leads to throwing errors on any operation with invalid descriptor.}

\item{dataPackage}{data package list}
}
\value{
\code{\link{Resource}} class object
}
\description{
Constructor to instantiate \code{Resource} class.
}
\examples{

# Resource Load - with base descriptor
descriptor <- '{"name":"name","data":["data"]}'
resource <- Resource.load(descriptor)
resource$name
resource$descriptor


# Resource Load - with tabular descriptor
descriptor2 <- '{"name":"name","data":["data"],"profile":"tabular-data-resource"}' 
resource2 <- Resource.load(descriptor2)
resource2$name
resource2$descriptor


# Retrieve Resource Descriptor
descriptor3 <- '{"name": "name","data": "data"}'
resource3 <- Resource.load(descriptor3)
resource3$descriptor


# Expand Resource Descriptor - General Resource
descriptor4 <- '{"name": "name","data": "data"}'
resource4 <- Resource.load(descriptor4)
resource4$descriptor

# Expand Resource Descriptor - Tabular Resource Dialect
descriptor5 <- helpers.from.json.to.list('{
                                        "name": "name",
                                        "data": "data",
                                        "profile": "tabular-data-resource",
                                        "dialect": {"delimiter": "custom"}
                                        }')
resource5 <- Resource.load(descriptor5)
resource5$descriptor


# Resource - Inline source/sourceType
descriptor6 <- '{"name": "name","data": "data","path": ["path"]}'
resource6 <- Resource.load(descriptor6)
resource6$source

# Resource - Remote source/sourceType
descriptor7 <- '{"name": "name","path": ["http://example.com//table.csv"]}'
resource7 <- Resource.load(descriptor7)
resource7$source 

# Resource - Multipart Remote source/sourceType
descriptor8 <- '{
              "name": "name",
              "path": ["http://example.com/chunk1.csv", "http://example.com/chunk2.csv"]
              }'
resource8 <- Resource.load(descriptor8)
resource8$source 

}
\seealso{
\code{\link{Resource}}, \href{https://frictionlessdata.io/specs/data-resource/}{Data Resource Specifications}
}
