/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.client.ClientProtocolException;
import org.dataone.client.D1RestClient;
import org.dataone.client.cache.LocalCache;
import org.dataone.client.exception.NotCached;
import org.dataone.configuration.Settings;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryEngineList;
import org.dataone.service.util.BigIntegerMarshaller;
import org.dataone.service.util.D1Url;
import org.dataone.service.util.DateTimeMarshaller;
import org.dataone.service.util.TypeMarshaller;
import org.jibx.runtime.JiBXException;

public abstract class D1Node {
    protected static Log log = LogFactory.getLog(D1Node.class);
    private String nodeBaseServiceUrl;
    private String nodeId;
    protected Session session;
    private boolean useLocalCache = false;
    private String lastRequestUrl = null;
    private Integer defaultSoTimeout = 30000;

    public String getLatestRequestUrl() {
        return this.lastRequestUrl;
    }

    protected void setLatestRequestUrl(String url) {
        this.lastRequestUrl = url;
    }

    public D1Node(String nodeBaseServiceUrl, Session session) {
        this.setNodeBaseServiceUrl(nodeBaseServiceUrl);
        this.session = session;
        this.useLocalCache = Settings.getConfiguration().getBoolean("D1Client.useLocalCache", this.useLocalCache);
    }

    public D1Node(String nodeBaseServiceUrl) {
        this.setNodeBaseServiceUrl(nodeBaseServiceUrl);
        this.session = null;
        this.useLocalCache = Settings.getConfiguration().getBoolean("D1Client.useLocalCache", this.useLocalCache);
    }

    @Deprecated
    public D1Node() {
    }

    public String getNodeBaseServiceUrl() {
        return this.nodeBaseServiceUrl;
    }

    public void setNodeBaseServiceUrl(String nodeBaseServiceUrl) {
        if (nodeBaseServiceUrl != null && !nodeBaseServiceUrl.endsWith("/")) {
            nodeBaseServiceUrl = nodeBaseServiceUrl + "/";
        }
        this.nodeBaseServiceUrl = nodeBaseServiceUrl;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Date ping() throws NotImplemented, ServiceFailure, InsufficientResources {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "monitor/ping");
        D1RestClient client = new D1RestClient();
        Header[] headers = null;
        try {
            headers = client.doGetRequestForHeaders(url.getUrl());
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)be;
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        Date date = null;
        for (Header header : headers) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("header: %s = %s", header.getName(), header.getValue()));
            }
            if (!header.getName().equals("Date")) continue;
            date = DateTimeMarshaller.deserializeDateToUTC((String)header.getValue());
        }
        if (date == null) {
            throw new ServiceFailure("0000", "Could not get date information from response's 'Date' header.");
        }
        return date;
    }

    public ObjectList listObjects() throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.listObjects(this.session);
    }

    public ObjectList listObjects(Session session) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.listObjects(session, null, null, null, null, null, null);
    }

    public ObjectList listObjects(Date fromDate, Date toDate, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        return this.listObjects(this.session, fromDate, toDate, formatid, replicaStatus, start, count);
    }

    public ObjectList listObjects(Session session, Date fromDate, Date toDate, ObjectFormatIdentifier formatid, Boolean replicaStatus, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        if (toDate != null && fromDate != null && !toDate.after(fromDate)) {
            throw new InvalidRequest("1000", "fromDate must be before toDate in listObjects() call. " + fromDate + " " + toDate);
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        url.addDateParamPair("fromDate", fromDate);
        url.addDateParamPair("toDate", toDate);
        if (formatid != null) {
            url.addNonEmptyParamPair("formatId", formatid.getValue());
        }
        if (replicaStatus != null) {
            if (replicaStatus.booleanValue()) {
                url.addNonEmptyParamPair("replicaStatus", Integer.valueOf(1));
            } else {
                url.addNonEmptyParamPair("replicaStatus", Integer.valueOf(0));
            }
        }
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.D1Node.listObjects.timeout", this.getDefaultSoTimeout()));
        ObjectList objectList = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            objectList = this.deserializeServiceType(ObjectList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return objectList;
    }

    public org.dataone.service.types.v1.Log getLogRecords() throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        return this.getLogRecords(null, null, null, null, null, null);
    }

    public org.dataone.service.types.v1.Log getLogRecords(Session session) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        return this.getLogRecords(session, null, null, null, null, null, null);
    }

    public org.dataone.service.types.v1.Log getLogRecords(Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        return this.getLogRecords(this.session, fromDate, toDate, event, pidFilter, start, count);
    }

    public org.dataone.service.types.v1.Log getLogRecords(Session session, Date fromDate, Date toDate, Event event, String pidFilter, Integer start, Integer count) throws InvalidToken, InvalidRequest, ServiceFailure, NotAuthorized, NotImplemented, InsufficientResources {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "log");
        url.addDateParamPair("fromDate", fromDate);
        url.addDateParamPair("toDate", toDate);
        if (event != null) {
            url.addNonEmptyParamPair("event", event.xmlValue());
        }
        url.addNonEmptyParamPair("start", start);
        url.addNonEmptyParamPair("count", count);
        url.addNonEmptyParamPair("pidFilter", pidFilter);
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.D1Node.getLogRecords.timeout", this.getDefaultSoTimeout()));
        org.dataone.service.types.v1.Log log = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            log = this.deserializeServiceType(org.dataone.service.types.v1.Log.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)be;
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return log;
    }

    public InputStream get(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources {
        return this.get(this.session, pid);
    }

    public InputStream get(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InsufficientResources {
        ByteArrayInputStream is = null;
        boolean cacheMissed = false;
        if (this.useLocalCache) {
            try {
                byte[] data = LocalCache.instance().getData(pid);
                is = new ByteArrayInputStream(data);
                return is;
            }
            catch (NotCached e) {
                cacheMissed = true;
            }
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        try {
            url.addNextPathElement(pid.getValue());
        }
        catch (IllegalArgumentException e) {
            throw new NotFound("0000", "'pid' cannot be null nor empty");
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.D1Node.get.timeout", this.getDefaultSoTimeout()));
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)client.doGetRequest(url.getUrl()));
            is = new ByteArrayInputStream(bytes);
            if (cacheMissed) {
                LocalCache.instance().putData(pid, bytes);
            }
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof InsufficientResources) {
                throw (InsufficientResources)be;
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return is;
    }

    public SystemMetadata getSystemMetadata(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.getSystemMetadata(this.session, pid, false);
    }

    public SystemMetadata getSystemMetadata(Identifier pid, boolean useSystemMetadataCache) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.getSystemMetadata(this.session, pid, useSystemMetadataCache);
    }

    public SystemMetadata getSystemMetadata(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.getSystemMetadata(session, pid, false);
    }

    public SystemMetadata getSystemMetadata(Session session, Identifier pid, boolean useSystemMetadataCache) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        boolean cacheMissed = false;
        if (useSystemMetadataCache) {
            try {
                SystemMetadata sysmeta = LocalCache.instance().getSystemMetadata(pid);
                return sysmeta;
            }
            catch (NotCached e) {
                cacheMissed = true;
            }
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "meta");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        D1RestClient client = new D1RestClient(session);
        client.setTimeouts(Settings.getConfiguration().getInteger("D1Client.D1Node.getSystemMetadata.timeout", this.getDefaultSoTimeout()));
        InputStream is = null;
        SystemMetadata sysmeta = null;
        try {
            is = client.doGetRequest(url.getUrl());
            sysmeta = this.deserializeServiceType(SystemMetadata.class, is);
            if (cacheMissed) {
                LocalCache.instance().putSystemMetadata(pid, sysmeta);
            }
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return sysmeta;
    }

    public DescribeResponse describe(Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return this.describe(this.session, pid);
    }

    public DescribeResponse describe(Session session, Identifier pid) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        BigInteger content_length;
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        if (pid == null || pid.getValue().trim().equals("")) {
            throw new NotFound("0000", "'pid' cannot be null nor empty");
        }
        url.addNextPathElement(pid.getValue());
        D1RestClient client = new D1RestClient(session);
        Header[] headers = null;
        HashMap<String, String> headersMap = new HashMap<String, String>();
        try {
            for (Header header : headers = client.doHeadRequest(url.getUrl())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("header: %s = %s", header.getName(), header.getValue()));
                }
                headersMap.put(header.getName(), header.getValue());
            }
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        String objectFormatIdStr = (String)headersMap.get("DataONE-ObjectFormat");
        String last_modifiedStr = (String)headersMap.get("Last-Modified");
        String content_lengthStr = (String)headersMap.get("Content-Length");
        String checksumStr = (String)headersMap.get("DataONE-Checksum");
        String serialVersionStr = (String)headersMap.get("DataONE-SerialVersion");
        try {
            content_length = BigIntegerMarshaller.deserializeBigInteger((String)content_lengthStr);
        }
        catch (JiBXException e) {
            throw new ServiceFailure("0", "Could not convert the returned content_length string (" + content_lengthStr + ") to a BigInteger: " + e.getMessage());
        }
        Date last_modified = null;
        try {
            if (last_modifiedStr != null) {
                last_modified = DateTimeMarshaller.deserializeDateToUTC((String)last_modifiedStr.trim());
            }
        }
        catch (NullPointerException e) {
            throw new ServiceFailure("0", "Could not parse the returned date string " + last_modifiedStr + ". The date string needs to be either ISO" + " 8601 compliant or http://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1 compliant: " + e.getMessage());
        }
        Checksum checksum = new Checksum();
        if (checksumStr != null) {
            String[] cs = checksumStr.split(",");
            checksum.setAlgorithm(cs[0]);
            if (cs.length > 1) {
                checksum.setValue(cs[1]);
            } else {
                throw new ServiceFailure("0", "malformed checksum header returned, checksum value not returned in the response");
            }
        }
        ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
        formatId.setValue(objectFormatIdStr);
        BigInteger serialVersion = null;
        try {
            serialVersion = BigIntegerMarshaller.deserializeBigInteger((String)serialVersionStr);
        }
        catch (JiBXException e) {
            throw new ServiceFailure("0", "Could not convert the returned serialVersion string (" + serialVersionStr + ") to a BigInteger: " + e.getMessage());
        }
        return new DescribeResponse(formatId, content_length, last_modified, checksum, serialVersion);
    }

    public Checksum getChecksum(Identifier pid, String checksumAlgorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        return this.getChecksum(this.session, pid, checksumAlgorithm);
    }

    public Checksum getChecksum(Session session, Identifier pid, String checksumAlgorithm) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound {
        if (pid == null) {
            throw new NotFound("0000", "PID cannot be null");
        }
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "checksum");
        url.addNextPathElement(pid.getValue());
        url.addNonEmptyParamPair("checksumAlgorithm", checksumAlgorithm);
        D1RestClient client = new D1RestClient(session);
        Checksum checksum = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            checksum = this.deserializeServiceType(Checksum.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return checksum;
    }

    public boolean isAuthorized(Identifier pid, Permission action) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        return this.isAuthorized(this.session, pid, action);
    }

    public boolean isAuthorized(Session session, Identifier pid, Permission action) throws ServiceFailure, InvalidRequest, InvalidToken, NotFound, NotAuthorized, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "isAuthorized");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        if (action != null) {
            url.addNonEmptyParamPair("action", action.xmlValue());
        }
        D1RestClient client = new D1RestClient(session);
        InputStream is = null;
        try {
            is = client.doGetRequest(url.getUrl());
            if (is != null) {
                is.close();
            }
        }
        catch (BaseException be) {
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return true;
    }

    public Identifier generateIdentifier(String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        return this.generateIdentifier(this.session, scheme, fragment);
    }

    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, InvalidRequest {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "generate");
        SimpleMultipartEntity smpe = new SimpleMultipartEntity();
        if (scheme == null) {
            throw new InvalidRequest("0000", "'scheme' cannot be null");
        }
        smpe.addParamPart("scheme", scheme);
        if (fragment != null) {
            smpe.addParamPart("fragment", fragment);
        }
        D1RestClient client = new D1RestClient(session);
        Identifier identifier = null;
        try {
            InputStream is = client.doPostRequest(url.getUrl(), smpe);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return identifier;
    }

    public Identifier archive(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.archive(this.session, pid);
    }

    public Identifier archive(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "archive");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        D1RestClient client = new D1RestClient(session);
        Identifier identifier = null;
        try {
            InputStream is = client.doPutRequest(url.getUrl(), null);
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return identifier;
    }

    public Identifier delete(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        return this.delete(this.session, pid);
    }

    public Identifier delete(Session session, Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "object");
        if (pid != null) {
            url.addNextPathElement(pid.getValue());
        }
        D1RestClient client = new D1RestClient(session);
        Identifier identifier = null;
        try {
            InputStream is = client.doDeleteRequest(url.getUrl());
            identifier = this.deserializeServiceType(Identifier.class, is);
        }
        catch (BaseException be) {
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return identifier;
    }

    public InputStream query(String queryEngine, D1Url queryUrlElements) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        return this.query(queryEngine, queryUrlElements.getUrl());
    }

    public InputStream query(String queryEngine, String encodedQuery) throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "query");
        try {
            url.addNextPathElement(queryEngine);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidRequest("0000", "'queryEngine' parameter cannot be null or empty");
        }
        if (StringUtils.isEmpty((String)encodedQuery)) {
            throw new InvalidRequest("0000", "'encodedQuery' parameter cannot be null or empty");
        }
        String finalUrl = url.getUrl() + "/" + encodedQuery;
        D1RestClient client = new D1RestClient(this.session);
        InputStream is = null;
        try {
            is = client.doGetRequest(finalUrl);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof InvalidRequest) {
                throw (InvalidRequest)((Object)be);
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return is;
    }

    public QueryEngineDescription getQueryEngineDescription(String queryEngine) throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "query");
        try {
            url.addNextPathElement(queryEngine);
        }
        catch (IllegalArgumentException e) {
            throw new NotFound("0000", "'queryEngine' cannot be null nor empty");
        }
        D1RestClient client = new D1RestClient(this.session);
        QueryEngineDescription description = null;
        try {
            InputStream is = client.doGetRequest(url.getUrl());
            description = this.deserializeServiceType(QueryEngineDescription.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            if (be instanceof NotFound) {
                throw (NotFound)((Object)be);
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return description;
    }

    public QueryEngineList listQueryEngines() throws InvalidToken, ServiceFailure, NotAuthorized, NotImplemented {
        D1Url url = new D1Url(this.getNodeBaseServiceUrl(), "query");
        InputStream is = null;
        D1RestClient client = new D1RestClient(this.session);
        QueryEngineList engines = null;
        try {
            is = client.doGetRequest(url.getUrl());
            engines = this.deserializeServiceType(QueryEngineList.class, is);
        }
        catch (BaseException be) {
            if (be instanceof NotImplemented) {
                throw (NotImplemented)((Object)be);
            }
            if (be instanceof NotAuthorized) {
                throw (NotAuthorized)be;
            }
            if (be instanceof ServiceFailure) {
                throw (ServiceFailure)((Object)be);
            }
            if (be instanceof InvalidToken) {
                throw (InvalidToken)be;
            }
            throw D1Node.recastDataONEExceptionToServiceFailure(be);
        }
        catch (ClientProtocolException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        catch (IllegalStateException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (IOException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure(e);
        }
        catch (HttpException e) {
            throw D1Node.recastClientSideExceptionToServiceFailure((Exception)((Object)e));
        }
        finally {
            this.setLatestRequestUrl(client.getLatestRequestUrl());
            client.closeIdleConnections();
        }
        return engines;
    }

    protected static ServiceFailure recastClientSideExceptionToServiceFailure(Exception e) {
        ServiceFailure sfe = new ServiceFailure("0 Client_Error", e.getClass() + ": " + e.getMessage());
        sfe.setStackTrace(e.getStackTrace());
        return sfe;
    }

    protected static ServiceFailure recastDataONEExceptionToServiceFailure(BaseException be) {
        ServiceFailure sfe = new ServiceFailure(be.getDetail_code(), "Recasted unexpected exception from the service - " + ((Object)((Object)be)).getClass() + ": " + be.getMessage());
        for (String key : be.getTraceKeySet()) {
            sfe.addTraceDetail(key, be.getTraceDetail(key));
        }
        return sfe;
    }

    protected <T> T deserializeServiceType(Class<T> domainClass, InputStream is) throws ServiceFailure {
        try {
            return (T)TypeMarshaller.unmarshalTypeFromStream(domainClass, (InputStream)is);
        }
        catch (JiBXException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
    }

    public Integer getDefaultSoTimeout() {
        return this.defaultSoTimeout;
    }

    public void setDefaultSoTimeout(Integer defaultSoTimeout) {
        this.defaultSoTimeout = defaultSoTimeout;
    }
}

