/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.PrologueSerializer;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public class QuerySerializer
implements QueryVisitor {
    static final int BLOCK_INDENT = 2;
    protected FormatterTemplate fmtTemplate;
    protected FormatterElement fmtElement;
    protected FmtExpr fmtExpr;
    protected IndentedWriter out = null;

    QuerySerializer(OutputStream _out, FormatterElement formatterElement, FmtExpr formatterExpr, FormatterTemplate formatterTemplate) {
        this(new IndentedWriter(_out), formatterElement, formatterExpr, formatterTemplate);
    }

    QuerySerializer(IndentedWriter iwriter, FormatterElement formatterElement, FmtExpr formatterExpr, FormatterTemplate formatterTemplate) {
        this.out = iwriter;
        this.fmtTemplate = formatterTemplate;
        this.fmtElement = formatterElement;
        this.fmtExpr = formatterExpr;
    }

    public void startVisit(Query query) {
    }

    public void visitResultForm(Query query) {
    }

    public void visitPrologue(Prologue prologue) {
        int row1 = this.out.getRow();
        PrologueSerializer.output(this.out, prologue);
        int row2 = this.out.getRow();
        if (row1 != row2) {
            this.out.newline();
        }
    }

    public void visitSelectResultForm(Query query) {
        this.out.print("SELECT ");
        if (query.isDistinct()) {
            this.out.print("DISTINCT ");
        }
        if (query.isReduced()) {
            this.out.print("REDUCED ");
        }
        this.out.print(" ");
        if (query.isQueryResultStar()) {
            this.out.print("*");
        } else {
            this.appendNamedExprList(query, this.out, query.getProject());
        }
        this.out.newline();
    }

    public void visitConstructResultForm(Query query) {
        this.out.print("CONSTRUCT ");
        if (query.isQueryResultStar()) {
            this.out.print("*");
            this.out.newline();
        } else {
            this.out.incIndent(2);
            this.out.newline();
            Template t = query.getConstructTemplate();
            t.visit(this.fmtTemplate);
            this.out.decIndent(2);
        }
    }

    public void visitDescribeResultForm(Query query) {
        this.out.print("DESCRIBE ");
        if (query.isQueryResultStar()) {
            this.out.print("*");
        } else {
            this.appendVarList(query, this.out, query.getResultVars());
            if (query.getResultVars().size() > 0 && query.getResultURIs().size() > 0) {
                this.out.print(" ");
            }
            QuerySerializer.appendURIList(query, this.out, query.getResultURIs());
        }
        this.out.newline();
    }

    public void visitAskResultForm(Query query) {
        this.out.print("ASK");
        this.out.newline();
    }

    public void visitDatasetDecl(Query query) {
        String uri;
        Iterator iter;
        if (query.getGraphURIs() != null && query.getGraphURIs().size() != 0) {
            iter = query.getGraphURIs().iterator();
            while (iter.hasNext()) {
                uri = (String)iter.next();
                this.out.print("FROM ");
                this.out.print(FmtUtils.stringForURI(uri, query));
                this.out.newline();
            }
        }
        if (query.getNamedGraphURIs() != null && query.getNamedGraphURIs().size() != 0) {
            iter = query.getNamedGraphURIs().iterator();
            while (iter.hasNext()) {
                uri = (String)iter.next();
                this.out.print("FROM NAMED ");
                this.out.print(FmtUtils.stringForURI(uri, query));
                this.out.newline();
            }
        }
    }

    public void visitQueryPattern(Query query) {
        if (query.getQueryPattern() != null) {
            this.out.print("WHERE");
            this.out.incIndent(2);
            this.out.newline();
            Element el = query.getQueryPattern();
            if (this.fmtElement.topMustBeGroup() && !(el instanceof ElementGroup)) {
                ElementGroup elg = new ElementGroup();
                elg.addElement(el);
                el = elg;
            }
            el.visit(this.fmtElement);
            this.out.decIndent(2);
            this.out.newline();
        }
    }

    public void visitGroupBy(Query query) {
        if (query.hasGroupBy()) {
            this.out.print("GROUP BY ");
            this.appendNamedExprList(query, this.out, query.getGroupBy());
            this.out.println();
        }
    }

    public void visitHaving(Query query) {
        if (query.hasHaving()) {
            this.out.print("HAVING");
            Iterator iter = query.getHavingExprs().iterator();
            while (iter.hasNext()) {
                this.out.print(" ");
                Expr expr = (Expr)iter.next();
                this.fmtExpr.format(expr);
            }
            this.out.println();
        }
    }

    public void visitOrderBy(Query query) {
        if (query.hasOrderBy()) {
            this.out.print("ORDER BY ");
            boolean first = true;
            Iterator iter = query.getOrderBy().iterator();
            while (iter.hasNext()) {
                if (!first) {
                    this.out.print(" ");
                }
                SortCondition sc = (SortCondition)iter.next();
                sc.format(this.fmtExpr, this.out);
                first = false;
            }
            this.out.println();
        }
    }

    public void visitLimit(Query query) {
        if (query.hasLimit()) {
            this.out.print("LIMIT   " + query.getLimit());
            this.out.newline();
        }
    }

    public void visitOffset(Query query) {
        if (query.hasOffset()) {
            this.out.print("OFFSET  " + query.getOffset());
            this.out.newline();
        }
    }

    public void finishVisit(Query query) {
        this.out.flush();
    }

    void appendVarList(Query query, IndentedWriter sb, List vars) {
        boolean first = true;
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            String varName = (String)iter.next();
            Var var = Var.alloc(varName);
            if (!first) {
                sb.print(" ");
            }
            sb.print(var.toString());
            first = false;
        }
    }

    void appendNamedExprList(Query query, IndentedWriter sb, VarExprList namedExprs) {
        boolean first = true;
        Iterator iter = namedExprs.getVars().iterator();
        while (iter.hasNext()) {
            Var var = (Var)((Object)iter.next());
            Expr expr = namedExprs.getExpr(var);
            if (!first) {
                sb.print(" ");
            }
            if (expr != null) {
                boolean needParens = true;
                if (expr.isFunction()) {
                    needParens = false;
                } else if (expr.isVariable()) {
                    needParens = false;
                }
                if (!Var.isAllocVar((Node)var)) {
                    needParens = true;
                }
                if (needParens) {
                    this.out.print("(");
                }
                this.fmtExpr.format(expr);
                if (!Var.isAllocVar((Node)var)) {
                    sb.print(" AS ");
                    sb.print(var.toString());
                }
                if (needParens) {
                    this.out.print(")");
                }
            } else {
                sb.print(var.toString());
            }
            first = false;
        }
    }

    static void appendURIList(Query query, IndentedWriter sb, List vars) {
        SerializationContext cxt = new SerializationContext(query);
        boolean first = true;
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (!first) {
                sb.print(" ");
            }
            sb.print(FmtUtils.stringForNode(node, cxt));
            first = false;
        }
    }
}

