% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R, R/CNode.R, R/MNode.R
\docType{methods}
\name{getSystemMetadata}
\alias{getSystemMetadata}
\alias{getSystemMetadata,CNode-method}
\alias{getSystemMetadata,MNode-method}
\title{Get the metadata describing system properties associated with an object on this Node.}
\usage{
getSystemMetadata(x, ...)

\S4method{getSystemMetadata}{CNode}(x, pid)

\S4method{getSystemMetadata}{MNode}(x, pid)
}
\arguments{
\item{x}{The Node instance from which the SystemMetadata will be downloaded}

\item{...}{(Not yet used.)}

\item{pid}{The identifier of the object}
}
\value{
SystemMetadata for the object

SystemMetadata for the object
}
\description{
The SystemMetadata includes information about the identity, type, access control, and other system
level details about the object.

The SystemMetadata includes information about the identity, type, access control, and other system
level details about the object.
}
\details{
This operation acts as the 'public' anonymous user unless an X.509 certificate is
present in the default location of the file system, in which case the access will be authenticated.

This operation acts as the 'public' anonymous user unless an X.509 certificate is
present in the default location of the file system, in which case the access will be authenticated.
}
\examples{
library(dataone)
cn <- CNode()
mn <- getMNode(cn, "urn:node:KNB")
pid <- "doi:10.5063/F1QN64NZ"
sysmeta <- getSystemMetadata(mn, pid)
library(dataone)
cn <- CNode()
pid <- "aceasdata.3.2"
sysmeta <- getSystemMetadata(cn, pid)
}
\seealso{
\code{\link[=CNode-class]{CNode}}{ class description.}
}
