% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsdr.R
\name{bsdr}
\alias{bsdr}
\title{Get Bloomberg SDR data}
\usage{
bsdr(dates, asset_class, currency = NULL)
}
\arguments{
\item{dates}{the dates for which data is required as Date or DateTime object.
It will use all date-time elements including year, month, day, hour,
minute, second (up to milliseconds) and  time zone information to determine
the set of trades to return. It will return the set of trades for the day
starting on \code{dates} if \code{dates} is of length one or the set of trades
between the first and second elements of \code{dates} if \code{dates} has a length
greater than one.}

\item{asset_class}{the asset class for which you would like to download trade
data. Valid inputs are \code{"CR"} (credit), \code{"IR"} (rates),
\code{"EQ"} (equities), \code{"FX"} (foreign exchange), \code{"CO"}
(commodities).}

\item{currency}{the currency for which you would like to get trades for.
These should be the currency's \href{https://en.wikipedia.org/wiki/ISO_4217}{ISO code}}
}
\value{
a tibble containing the requested data, or an empty tibble if
data is unavailable. Note that fields containing notional information are
not necessarily numeric values are capped in public data to meet CFTC
requirements.
}
\description{
The Bloomberg Swap Data Repository (BSDR) is a registered U.S. swap data
repository that allows market participants to fulfil their public disclosure
obligations under U.S. legislation. BSDR is required to make publicly
available price, trading volume and other trading data reported to its U.S.
repository. It publishes this data on its website in real-time and also on a
historical basis. I have reverse engineered the JavaScript libraries used by
its website to call the Bloomberg Application Service using \code{POST}
requests to a target URL.
}
\examples{
\dontrun{
library (lubridate)
# Interest rate trades for day starting 19 May 2017
bsdr(ymd(20170519), "IR")
# Interest rate trades for the period between 19 May 2017 and 23 May 2017
bsdr(ymd(20170519, 20170523), "IR")
}
}
\references{
\href{http://www.bloombergsdr.com/search}{BSDR search}
\href{https://www.bloombergsdr.com/api}{Bloomberg SDR API}
}
