% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bsef.R
\name{get_bsef_data}
\alias{get_bsef_data}
\title{Get Bloomberg SEF data}
\usage{
get_bsef_data(date, asset_class = NULL, curate = TRUE)
}
\arguments{
\item{date}{the date for which data is required as Date or DateTime object.
Only the year, month and day elements of the object are used. Must be of
length one.}

\item{asset_class}{the asset class for which you would like to download
trade data. Valid inputs are \code{"CR"} (credit), \code{"IR"} (rates),
\code{"EQ"} (equities), \code{"FX"} (foreign exchange), \code{"CO"}
(commodities). Can be a vector of these. Defaults to \code{NULL} which
corresponds to all asset classes.}

\item{curate}{a logical flag indicating whether raw data should be returned
or whether the raw data should be processed (default). The latter involves
selecting particular fields and formatting these as seemed appropriate
based on data and API reviews at the time the formatting was coded.}
}
\value{
a data frame containing the requested data, or an empty data frame
  if data is unavailable
}
\description{
The Bloomberg Swap Execution Facility (SEF) offers customers the ability to
execute derivative instruments across a number of different asset classes.
It is required to make publicly available price, trading volume and other
trading data. It publishes this data on its website. I have reverse
engineered the JavaScript libraries used by its website to call the
Bloomberg Application Service using \code{POST} requests to a target URL.
}
\examples{
\dontrun{
library (lubridate)
# All asset classes
get_bsef_data(ymd(20140528))
# Only IR and FX asset classes
get_bsef_data(ymd(20140528), c("IR", "FX"))
}
}
\references{
\href{http://data.bloombergsef.com}{Bloomberg SEF data}
}

