% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-file.R
\name{import-file}
\alias{import-file}
\alias{import_file_ui}
\alias{import_file_server}
\title{Import data from a file}
\usage{
import_file_ui(id, title = TRUE)

import_file_server(
  id,
  btn_show_data = TRUE,
  trigger_return = c("button", "change"),
  return_class = c("data.frame", "data.table", "tbl_df")
)
}
\arguments{
\item{id}{Module's ID.}

\item{title}{Module's title, if \code{TRUE} use the default title,
use \code{NULL} for no title or a \code{shiny.tag} for a custom one.}

\item{btn_show_data}{Display or not a button to display data in a modal window if import is successful.}

\item{trigger_return}{When to update selected data:
\code{"button"} (when user click on button) or
\code{"change"} (each time user select a dataset in the list).}

\item{return_class}{Class of returned data: \code{data.frame}, \code{data.table} or \code{tbl_df} (tibble).}
}
\value{
\itemize{
\item UI: HTML tags that can be included in shiny's UI
\item Server: a \code{list} with three slots:
\itemize{
\item \strong{status}: a \code{reactive} function returning the status: \code{NULL}, \code{error} or \code{success}.
\item \strong{name}: a \code{reactive} function returning the name of the imported data as \code{character}.
\item \strong{data}: a \code{reactive} function returning the imported \code{data.frame}.
}
}
}
\description{
Let user upload a file and import data
}
\examples{


library(shiny)
library(datamods)

ui <- fluidPage(
  tags$h3("Import data from a file"),
  fluidRow(
    column(
      width = 4,
      import_file_ui("myid")
    ),
    column(
      width = 8,
      tags$b("Imported data:"),
      verbatimTextOutput(outputId = "status"),
      verbatimTextOutput(outputId = "data")
    )
  )
)

server <- function(input, output, session) {

  imported <- import_file_server("myid")

  output$status <- renderPrint({
    imported$status()
  })
  output$data <- renderPrint({
    imported$data()
  })

}

if (interactive())
  shinyApp(ui, server)
}
