% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extraer_noticias_fecha.R
\name{extraer_noticias_fecha}
\alias{extraer_noticias_fecha}
\title{Extraccion de noticias de medios chilenos por rango de fechas}
\usage{
extraer_noticias_fecha(
  search_query,
  fecha_inicio,
  fecha_fin,
  subir_a_bd = TRUE,
  fuentes = "todas"
)
}
\arguments{
\item{search_query}{Una frase de busqueda (obligatoria).}

\item{fecha_inicio}{Fecha de inicio del rango de busqueda en formato "YYYY-MM-DD" (obligatoria).}

\item{fecha_fin}{Fecha de fin del rango de busqueda en formato "YYYY-MM-DD" (obligatoria).}

\item{subir_a_bd}{por defecto TRUE, FALSE para test y cosas por el estilo (opcional).}

\item{fuentes}{es un string con las fuentes a extraer. Puede ser bbcl o las de emol.}
}
\value{
Un dataframe con las noticias extraidas.
}
\description{
Esta funcion permite realizar una extraccion automatizada de noticias de
BioBio o Los medios de Emol, utilizando un rango de fechas.
}
\examples{
\dontrun{
noticias <- extraer_noticias_fecha("delincuencia", "2025-04-25",
"2025-04-28", subir_a_bd = FALSE, fuentes="bbcl")
}
}
