% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grafico_notas_por_mes.R
\name{grafico_notas_por_mes}
\alias{grafico_notas_por_mes}
\title{Grafico de notas por mes}
\usage{
grafico_notas_por_mes(datos, titulo, fecha_inicio = NULL, fecha_fin = NULL)
}
\arguments{
\item{datos}{Data frame con los datos procesados, que debe incluir la columna `fecha` en formato YYYY-MM-DD.}

\item{titulo}{Texto que aparecera en el titulo del grafico.}

\item{fecha_inicio}{Fecha de inicio para la construccion del grafico en formato YYYY-MM-DD (opcional).}

\item{fecha_fin}{Fecha de finalizacion para la construccion del grafico en formato YYYY-MM-DD (opcional).}
}
\value{
Un grafico ggplot2 que muestra la cantidad de publicaciones por mes.
}
\description{
Esta funcion genera un grafico de linea que muestra la cantidad de publicaciones agrupadas por mes.
}
\examples{
\donttest{
datos <- extraer_noticias_fecha("cambio climatico", "2024-01-01","2025-01-01", subir_a_bd = FALSE)
grafico_notas_por_mes(datos, titulo = "Cambio Climatico",
fecha_inicio = "2024-01-01", fecha_fin = "2024-06-06")
}

}
