% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddo_ddf_methods.R
\name{convert}
\alias{convert}
\title{Convert 'ddo' / 'ddf' Objects}
\usage{
convert(from, to, overwrite = FALSE)
}
\arguments{
\item{from}{a 'ddo' or 'ddf' object}

\item{to}{a 'kvConnection' object (created with \code{\link{localDiskConn}} or \code{\link{hdfsConn}}) or \code{NULL} if an in-memory 'ddo' / 'ddf' is desired}

\item{overwrite}{should the data in the location pointed to in \code{to} be overwritten?}
}
\description{
Convert 'ddo' / 'ddf' objects between different storage backends
}
\examples{
d <- divide(iris, by = "Species")
# convert in-memory ddf to one stored on disk
dl <- convert(d, localDiskConn(tempfile(), autoYes = TRUE))
dl
}

