% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divSpec_rrDiv.R
\name{rrDiv}
\alias{rrDiv}
\title{Random Replicate Division}
\usage{
rrDiv(nrows = NULL, seed = NULL)
}
\arguments{
\item{nrows}{number of rows each subset should have}

\item{seed}{the random seed to use (experimental)}
}
\value{
a list to be used for the "by" argument to \code{\link{divide}}
}
\description{
Specify random replicate division parameters for data division
}
\details{
The random replicate division method currently gets the total number of rows of the input data and divides it by \code{nrows} to get the number of subsets.  Then it randomly assigns each row of the input data to one of the subsets, resulting in subsets with approximately \code{nrows} rows.  A future implementation will make each subset have exactly \code{nrows} rows.
}
\examples{
# divide iris data into random subsets with ~20 records per subset
irisRR <- divide(iris, by = rrDiv(20), update = TRUE)
irisRR
# look at the actual distribution of number of rows per subset
plot(splitRowDistn(irisRR))
}
\author{
Ryan Hafen
}
\references{
\itemize{
 \item \url{http://tessera.io}
 \item \href{http://onlinelibrary.wiley.com/doi/10.1002/sta4.7/full}{Guha, S., Hafen, R., Rounds, J., Xia, J., Li, J., Xi, B., & Cleveland, W. S. (2012). Large complex data: divide and recombine (D&R) with RHIPE. \emph{Stat}, 1(1), 53-67.}
}
}
\seealso{
\code{\link{divide}}, \code{\link{recombine}}, \code{\link{condDiv}}
}

