% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-join.R
\name{check_join}
\alias{check_join}
\title{Check Join}
\usage{
check_join(data, parent, join = NULL, referential = TRUE, extra = FALSE,
  ignore_nas = FALSE, data_name = substitute(data),
  parent_name = substitute(parent))
}
\arguments{
\item{data}{The data frame to check.}

\item{parent}{A data frame of the parent table.}

\item{join}{A character vector of the join columns. Use a named character vector
if the names of the columns differ.}

\item{referential}{A flag indicating whether to check for referential integrity.}

\item{extra}{A flag indicating whether to allow additional matching columns.}

\item{ignore_nas}{A flag indicating whether to ignore missing values or
treat them as values.}

\item{data_name}{A string of the name of data.}

\item{parent_name}{A string of the name of parent.}
}
\value{
Throws an informative error or returns an invisible copy of
data.
}
\description{
Checks that the columns in a data frame form a many-to-one
join with correponding columns in parent.
}
\details{
By default (\code{join = NULL}) all the columns in parent represent the join key.
}
\seealso{
\code{\link{datacheckr}}
}

