% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datacheck.R
\name{is_one_of}
\alias{is_one_of}
\title{Tests if a string or 'factor level' is one of a pre-defined set}
\usage{
is_one_of(x, aset)
}
\arguments{
\item{x}{a factor level as character string}

\item{aset}{a vector of character strings or a path to a custom file (full pathname where necessary)}
}
\value{
boolean TRUE if detects anything
}
\description{
The aset parameter may point to a file with level names.
This is useful if there are many levels like in database of world countries.
The file path may be an absolute one or relative to the current working directory.
}
\details{
The supporting table must have two columns named 'VALUES' and 'LABELS'.
The lookup file must be in comma separated format and using the '.csv' extension. It must
also be encoded using UTF-8 character set for being able to use foreign characters across
operating systems. This is often an issue when using Excel to develop the file.

The x parameter may have just one level or multiple levels separated by ';'. Likewise the aset
parameter may have just one level or multiple levels separated by ';'. In any case the x parameter
must be a subset of aset (or the lookup file): see the example section.
}
\examples{
# Case 1: define the reference set or lookup set within the function. Useful for small or binary
# sets like m(ale)/f(emale)
is_one_of("m", "m") == TRUE

is_one_of("m", c("f", "m")) == TRUE

is_one_of("y", c("f", "m")) == FALSE

is_one_of(c("b", "c", "d"), c("a", "b", "c", "d", "e")) == TRUE


# Case 2: use an external lookup table. The external lookup table must have at least one column
# called exactly 'VALUES'. May have also another one 'LABELS'. Useful for long lookup tables like
# list of countries.

# some preparation work for using a temporary directory
owd <- getwd()
td <- tempdir()
setwd(td)


VALUES <- LETTERS[1:10]
LABELS <- VALUES
db <- cbind(VALUES, LABELS)
db <- as.data.frame(db, stringsAsFactors = FALSE)
names(db) <- c("VALUES", "LABELS")
write.csv(db, "sample.csv", row.names = FALSE)

is_one_of("A", "sample.csv") == TRUE
is_one_of("Z", "sample.csv") == FALSE

# switching back to your working directory
setwd(owd)
 
}
\author{
Reinhard Simon, Jose Francisco Loff
}
\seealso{
Other rule_checks: \code{\link{has.punct}};
  \code{\link{has_punct}}; \code{\link{is.oneOf}};
  \code{\link{is.onlyLowers}}; \code{\link{is.properName}};
  \code{\link{is.withinRange}};
  \code{\link{is_only_lowers}};
  \code{\link{is_proper_name}};
  \code{\link{is_within_range}}
}

