% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_api_requests.R
\name{construct_api_requests}
\alias{construct_api_requests}
\title{Create API url}
\usage{
construct_api_requests(
  service,
  properties = NA_character_,
  bbox = NA,
  limit = NA,
  max_results = NA,
  skipGeometry = FALSE,
  ...
)
}
\arguments{
\item{service}{Which service available on \url{https://api.waterdata.usgs.gov/ogcapi/v0/}.}

\item{properties}{The properties that should be included for each feature. The
parameter value is a comma-separated list of property names which depend on the
service being called.}

\item{bbox}{Only features that have a geometry that intersects the bounding
box are selected.The bounding box is provided as four or six numbers, depending
on whether the coordinate reference system includes a vertical axis (height or
depth).}

\item{limit}{The optional limit parameter limits the number of items that are
presented in the response document. Only items are counted that are on the
first level of the collection in the response document. Nested objects
contained within the explicitly requested items shall not be counted.}

\item{skipGeometry}{This option can be used to skip response geometries for
each feature. The returning object will be a data frame with no spatial
information.}

\item{...}{Extra parameters from the specific services.}
}
\description{
Main documentation: \url{https://api.waterdata.usgs.gov/ogcapi/v0/},
Swagger docs: \url{https://api.waterdata.usgs.gov/ogcapi/v0/openapi?f=html}.
}
\examples{
site <- "USGS-02238500"
pcode <- "00060"
req_dv <- construct_api_requests("daily",
                                 monitoring_location_id = site,
                                 parameter_code = "00060")

req_dv <- construct_api_requests("daily",
                                 monitoring_location_id = site,
                                 parameter_code = c("00060", "00065"))

sites <- c("USGS-01491000", "USGS-01645000")
start_date <- "2018-01-01"
end_date <- "2022-01-01"
req_dv <- construct_api_requests("daily",
                                monitoring_location_id = sites,
                                parameter_code = c("00060", "00065"),
                                datetime = c(start_date, end_date))

}
\keyword{internal}
