% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/readNWISdata.r
\name{readNWISdata}
\alias{readNWISdata}
\title{General Data Import from NWIS}
\usage{
readNWISdata(service = "dv", ...)
}
\arguments{
\item{service}{string. Possible values are "iv" (for instantaneous), "dv" (for daily values), "gwlevels"
(for groundwater levels), and "site" (for site service)}

\item{\dots}{see \url{http://waterservices.usgs.gov/rest/Site-Service.html#Service} for a complete list of options}
}
\value{
A data frame with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
agency \tab character \tab The NWIS code for the agency reporting the data\cr
site \tab character \tab The USGS site number \cr
datetime \tab POSIXct \tab The date and time of the value converted to UTC (for unit value data), \cr
\tab character \tab or raw character string \cr
tz_cd \tab character \tab The time zone code for datetime \cr
code \tab character \tab Any codes that qualify the corresponding value\cr
value \tab numeric \tab The numeric value for the parameter \cr
}
Note that code and value are repeated for the parameters requested. The names are of the form
X_D_P_S, where X is literal,
D is an option description of the parameter,
P is the parameter code,
and S is the statistic code (if applicable).

There are also several useful attributes attached to the data frame:
\tabular{lll}{
Name \tab Type \tab Description \cr
url \tab character \tab The url used to generate the data \cr
siteInfo \tab data.frame \tab A data frame containing information on the requested sites \cr
variableInfo \tab data.frame \tab A data frame containing information on the requested parameters \cr
statisticInfo \tab data.frame \tab A data frame containing information on the requested statistics on the data \cr
queryTime \tab POSIXct \tab The time the data was returned \cr
}
}
\description{
Returns data from the NWIS web service.
Arguments to the function should be based on \url{http://waterservices.usgs.gov} service calls.
}
\examples{
\dontrun{
# Examples not run for time considerations
dataTemp <- readNWISdata(stateCd="OH",parameterCd="00010")
dataTempUnit <- readNWISdata(sites="03086500", service="iv", parameterCd="00010")
#Empty:
multiSite <- readNWISdata(sites=c("04025000","04072150"), service="iv", parameterCd="00010")
#Not empty:
multiSite <- readNWISdata(sites=c("04025500","040263491"), service="iv", parameterCd="00060")
bBoxEx <- readNWISdata(bBox=c(-83,36.5,-81,38.5), parameterCd="00010")

startDate <- as.Date("2013-10-01")
endDate <- as.Date("2014-09-30")
waterYear <- readNWISdata(bBox=c(-83,36.5,-81,38.5), parameterCd="00010",
                  service="dv", startDate=startDate, endDate=endDate)
siteInfo <- readNWISdata(stateCd="WI", parameterCd="00010",
                  hasDataTypeCd="iv", service="site")
}
}
\seealso{
\code{\link{renameNWISColumns}},  \code{\link{importWaterML1}}, \code{\link{importRDB1}}
}
\keyword{NWIS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

